;;;
;;; Shared Object Hierarchy
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/soh/RCS/aux.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:08:49 $
;;;

(in-package clos)

;;; 
;;; Functions that we need but not directly available in PCL.
;;;

(defun class-instance-slots (class)
  (let ((class-slots (class-slots class)))
    (dolist (s class-slots)
	    (if (eq (slotd-allocation s) ':class)
		(setq class-slots (remove s class-slots))))
    class-slots))

(defun class-class-slots (class)
  (let ((class-slots (class-slots class)))
    (dolist (s class-slots)
	    (if (eq (slotd-allocation s) ':instance)
		(setq class-slots (remove s class-slots))))
    class-slots))

(defun class-local-instance-slots (class)
  (let ((class-slots (class-local-slots class)))
    (dolist (s class-slots)
	    (if (eq (slotd-allocation s) ':class)
		(setq class-slots (remove s class-slots))))
    class-slots))

(defun class-local-class-slots (class)
  (let ((class-slots (class-local-slots class)))
    (dolist (s class-slots)
	    (if (eq (slotd-allocation s) ':instance)
		(setq class-slots (remove s class-slots))))
    class-slots))
