;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/misc/RCS/qual-widget.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:08:32 $
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/misc/RCS/qual-widget.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:08:32 $

(in-package "PT")

;;;
;;; A qual-widget is effectively two labels, one of which pops up a menu when
;;; button upon (see pop-buttom for details).  It looks something like the
;;; following:
;;;		 ______________________________
;;;		|			       |
;;;		|  Goal:  75%	Result:  50%   |	
;;;		|______________________________|
;;;
;;; All fields are customizable at instantiation (see new-instance method)
;;; and the data fields (currently "75%" and "50%") can be accessed
;;; dynamically as well, by means of the "goal" and "result" accessor methods.
;;; When I click on "75%" above, the goal field is inverted and a list of
;;; menu options pops up.  If a menu item is selected, the menu goes away
;;; and the goal field is replaced by the chosen item.  The process is
;;; aborted if the mouse is released outside of the menu-pane.
;;; The menu items can be set dynamically and/or at instantiation by means
;;; of the "items" accessor.  
;;;
;;; NOTE: the result field ("50%" in above example) can be bound dynamically
;;; to some function on goal by using a bind-slot.  For example:
;;; 	(bind-slot 'result qw `(let ((goal (var goal ,qw)))
;;;				    (cond ((string= goal "75%") "50%")
;;;					  ((string= goal "50%") "25%")
;;;					  (t "0%"))))
;;; see documentation on binding for more info.
;;;

(defclass qual-widget (collection-widget)
  ((goal
    :initarg :goal 
    :initform nil
    :type window)
   (result
    :initarg :result 
    :initform nil
    :type window)
    (gm :initform 'anchor-gm)))

(defun make-qual-widget (&rest args)
  (apply #'make-instance 'qual-widget :allow-other-keys t args))

;;;
;;;	Accessor Methods
;;;

(defmethod goal ((self qual-widget) &aux win)
  (when (window-p (setq win (slot-value self 'goal)))
	(value win)))

(defmethod (setf goal) (val (self qual-widget) &aux win)
  (when (window-p (setq win (slot-value self 'goal)))
	(setf (value win) val)))

(defmethod result ((self qual-widget) &aux win)
  (when (window-p (setq win (slot-value self 'result)))
	(value win)))

(defmethod (setf result) (val (self qual-widget) &aux win)
  (when (window-p (setq win (slot-value self 'result)))
	(setf (value win) val)))

(defmethod value ((self qual-widget) 
		  &key 
		  &allow-other-keys
		  &aux g r)
  (when (and (window-p (setq g (slot-value self 'goal)))
	     (window-p (setq r (slot-value self 'result))))
	(when (listp (setq g (value g))) 
	      (setq g (car g)))
	(when (listp (setq r (value r)))
	      (setq r (car r)))
	(cons g r)))

(defmethod (setf value) (val (self qual-widget) &aux g r)
  (when (and (window-p (setq g (slot-value self 'goal)))
	     (window-p (setq r (slot-value self 'result))))
	(setf (value g) (car val)
	      (value r) (cdr val))))

;;;
;;;	Instantiate a qual-widget
;;;

(defmethod new-instance ((self qual-widget)
			 &key
			 (first-title	"Goal:")
			 (second-title	"Result:")
			 (first-value	"")
			 (second-value	"")
			 (first-font	nil)
			 (second-font	nil)
			 (font		nil)
			 (items 	nil)
			 (orientation	:left)
			 &allow-other-keys
			 &aux p-button tg)
  (call-next-method)

  (when font (setq first-font font
		   second-font font))
  (unless first-font (setq first-font (make-font)))
  (unless second-font (setq second-font first-font))
  (setq p-button (make-pop-button
		  :parent self
		  :label first-title
		  :label-type orientation
		  :value first-value
		  :font first-font
		  :border-width 0
		  :items (mapcar 
			   #'(lambda (x) (list x `(setf (goal ',self) ,x)))
			   items)
		  :geom-spec '(1/4 0 1/4 1 :arrow (:horiz :vert))))

  (setq tg (make-text-gadget
	    :label second-title
	    :parent self
	    :label-type orientation
	    :value second-value
	    :font second-font
	    :geom-spec '(3/4 0 1/4 1 :arrow (:horiz :vert))))

  (setf (slot-value self 'goal) p-button
	(slot-value self 'result) tg))
