;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/misc/RCS/enclosure-widget.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:08:32 $
;;;

(in-package "PT")

;;;
;;; an enclosure widget is just a collection which holds a gadget.
;;; it's chief use is to get a gadget to receive events.
;;;

(defclass enclosure-widget (collection-widget)
  ())

(defun make-enclosure-widget (&rest args)
  (apply #'make-instance 'enclosure-widget :allow-other-keys t args))

;;;
;;; value method and setf just refer to enclosed gadget
;;;

(defmethod value ((self enclosure-widget) 
		  &key 
		  &allow-other-keys
		  &aux ch)
  (when (setq ch (children self))
	(value (car ch))))

(defmethod (setf value) (val (self enclosure-widget) &aux ch)
  (when (setq ch (children self))
	(setf (value (car ch)) val)))

