;;;
;;; Postgres/CommonLISP interface
;;;
;;; Copyright (c) 1986 Regents of the University of California
;;; 
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/libpq/RCS/blocks.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:08:18 $
;;;

(in-package libpq)

;;;
;;; Data structures maintained by functions in this file are used
;;; to store the tuple data fetched from the POSTGRES backend.
;;;


;;; 
;;; Routines maintaining blocks storing portal information -- pblocks.
;;;

;;;
;;; Append a pblock to PBlist
;;;
(defun putpblock (pblock) 
  (setf (aref pblock (1- PBsize)) nil)
  (push pblock PBlist))

;;;
;;; Get a pblock from PBlist
;;;
(defun getpblock ()
  (if (not (null PBlist))
      (pop PBlist)
    (make-array PBsize :element-type t)))


;;; 
;;; Routines maintaining blocks storing type information -- tblocks.
;;;

;;;
;;; Append a tblock to TBlist
;;;
(defun puttblock (tblock) 
  (setf (aref tblock (1- TBsize)) nil)
  (push tblock TBlist))

;;;
;;; Get a tblock from TBlist
;;;
(defun gettblock()
  (if (not (null TBlist))
      (pop TBlist)
    (make-array TBsize :element-type t)))

;;; 
;;; Routines maintaining blocks storing tuple indexes -- iblocks.
;;;

;;;
;;; Append an iblock to IBlist
;;;
(defun putiblock (iblock) 
  (setf (aref iblock (1- IBsize)) nil)
  (push iblock IBlist))

;;;
;;; Get an iblock from IBlist
;;;
(defun getiblock ()
  (if (not (null IBlist))
      (pop IBlist)
    (make-array IBsize :element-type t)))


;;; 
;;; Routines maintaining tuple value blocks -- vblocks.
;;;

;;;
;;; Append a vblock to VBlist
;;;
(defun putvblock (vblock) 
  (pushnew vblock VBlist))

;;;
;;; Get a vblock from VBlist
;;;

(defun getvblock ()
  (if (not (null VBlist))
      (pop VBlist)
    (make-array VBsize :element-type 'character)))

;(defun getvblock ()
;  (if (not (null VBlist))
;      (pop VBlist)
;    (makevblock VBsize)))


(setq G-VBLOCK (getvblock))



