;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/image/RCS/paint-gadget.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:08:15 $
;;;

(in-package "PT")

;;;
;;;	A paint-gadget displays an arbitrary paint (a color or image)
;;;	Images are tiled instead of put.
;;;

;;;
;;; Definition of the paint-gadget class
;;;

(defclass paint-gadget (gadget)
  ((gc-spec :initform '(gc-res "default"))))

(defun make-paint-gadget (&rest keys)
  (apply #'make-instance 'paint-gadget :allow-other-keys t keys))

(defmethod (setf value) (val (self paint-gadget))
  (setf (slot-value self 'value) val)
  (setf (background self) val)
  (repaint self))

(defmethod do-repaint ((self paint-gadget)
		       &key 
		       &allow-other-keys)
  (clear self))
