
;;;
;;;  HYPER-GRAPHIC-WIDGET
;;;  Widget for displaying graphic nodes in HIP:
;;;     

(in-package "PT")

;;;  Relevant slots from graphic-browser: xmin/max/left/right;
;;;  ymin/max/bottom/top; selection; selectables; search-red


(defclass hyper-graphic-widget (hypermedia-mixin graphic-browser)
  (
;;  (event-mask :initform '(:button-press :button-1-motion :keypress
;;					 :exposure :double-click))
   )
  (:documentation "Graphic widgets with hypermedia behavior"))

(defun make-hyper-graphic-widget (&rest args)
  (apply #'make-instance 'hyper-graphic-widget args))

(defmethod new-instance ((self hyper-graphic-widget) 
			 &key node 
			 &allow-other-keys)
  (call-next-method)
  (when node
	(setf (viewer node) self)
	(setup-node self node))
  ;; temporary kludge to get these guys to listen to the right events:
  (register-callback (widget self) #'show-link-menu 
		     :button-press :detail :left-button :state :control)
  (register-callback (widget self) #'follow-default-link
		     :button-press :detail :middle-button :state :control)
  (register-callback (widget self) #'hyper-position-mark
		     :button-press :detail :right-button))
  

(defmethod widget ((self hyper-graphic-widget))
  ;; no underlying widget here, since we inherit from graphic-browser
  self)

;;;
;;;  Methods for setting up and saving node correctly:
;;;

(defmethod setup-node ((self hyper-graphic-widget) (n graphic-node))
  ;; get the contents of the graphic file and put them into the buffer:
 ;; (load-file self (dataset n))
  (unmodify n)
  )

(defmethod save ((gn graphic-node) &optional hw)
  (with-feedback (format nil "Saving file ~a" (dataset gn))
	 (progn
	   (when hw
		 (save-link-info hw))
	   (unmodify gn))))

;;;
;;; Methods for setting and querying the current state of the widget:
;;;

(defmethod set-position ((self hyper-graphic-widget)
			 &key x y &allow-other-keys)
  (text-widget-position-cursor (widget self) :x x :y y))

;;  Seems that we need this one as well, until we can move the event
;;  handlers from the widget to the hyper-widget:
(defmethod set-position ((self hyper-graphic-widget)
			 &key x y &allow-other-keys)
  (text-widget-position-cursor (widget self) :x x :y y))
  
(defmethod get-mark-region ((self hyper-graphic-widget))
  ;; returns marked region as ((br . bc) (er . ec))
  (let ((begin (cons (mark-row self) (mark-column self)))
	(end (cons (row self) (column self))))
    (if (< (car begin) (car end))
	(list begin end)
      (list end begin))))

#| (defmethod get-current-link-marker ((self hyper-graphic-widget) row col)
  ;; looks for all link-markers containing given point, returning the first one:
  (declare (ignore col))
  (let ((candidate-link-markers (remove-if-not #'(lambda (b) (and (>= row (car (offset b)))
							    (<= row (car (end b)))))
					 (link-markers (node self)))))
    (if candidate-link-markers
	(car (last candidate-link-markers))
      nil)))  |#

(defmethod get-current-link-marker ((self hyper-graphic-widget))
  (car (last (link-markers (node self)))))

  
(defmethod unmark-marker ((self hyper-graphic-widget) (b marker))
  "sets point and mark to beginning of block, un-highlighting it"
  (let ((tw (graphic-widget self)))
       (setf (row tw) (car (offset b)))
       (setf (column tw) (cdr (offset b)))
       (setf (mark-row tw) (car (offset b)))
       (setf (mark-column tw) (cdr (offset b)))
       (tbg-repaint tw :start-row (row tw) :start-column (column tw)
		    :end-row (mark-row tw) :end-column (mark-column tw))))

(defmethod exposed-markers ((self hyper-graphic-widget))
  (let* ((tr (top-of-screen (text-widget self)))
	 (br (+ tr (rows self))))
    (remove-if-not #'(lambda (b) (or (and (>= (car (offset b)) tr)
					  (<  (car (offset b)) br))
				     (and (>= (car (end b)) tr)
					  (< (car (end b)) br))))
		   (markers (node self)))))


(defmethod scroll-to ((self hyper-graphic-widget) offset)
  "offset is (row . col) in the graphic widget"
  (let  ((tw (text-widget self))
	 (row (car offset))
	 (col (cdr offset))  ;; ignored for now
	 (r (row self)))
    (declare (ignore col))
    (when (not (= r row))
	  (if (< r row)
	      (tbg-scroll-down tw (- row r))
	    (tbg-scroll-up tw (- r row))))))

;;;
;;;  Event handlers:
;;;

(defhandler position-mark ((self hyper-graphic-widget)
			   &key x y &allow-other-keys
			   &default
			   (:button-press :detail :right-button))
  (hyper-position-mark self :x x :y y))

(defun hyper-position-mark (self &key x y &allow-other-keys)
  (cond  ((eq (class-of self) (find-class 'text-widget))
	  (text-widget-position-mark self :x x :y y)))
  ;; make this panel the current panel:
  (make-current (my-panel self)))
  
;;;
;;;  The following methods provide access to attributes of the
;;;  underlying graphic widget:
;;;

(defmethod row ((self hyper-graphic-widget))
  (row (text-widget self)))
(defmethod (setf row) (row (self hyper-graphic-widget))
  (setf (row (text-widget self)) row))

(defmethod mark-row ((self hyper-graphic-widget))
  (mark-row (text-widget self)))
(defmethod (setf mark-row) (row (self hyper-graphic-widget))
  (setf (mark-row (text-widget self)) row))

(defmethod column ((self hyper-graphic-widget))
  (column (text-widget self)))
(defmethod (setf column) (column (self hyper-graphic-widget))
  (setf (column (text-widget self)) column))

(defmethod mark-column ((self hyper-graphic-widget))
  (mark-column (text-widget self)))
(defmethod (setf mark-column) (column (self hyper-graphic-widget))
  (setf (mark-column (text-widget self)) column))

;;;  Methods on graphic-widget:

