
;;;
;;;  DB-ACCESS.CL
;;;  This file contains functions for fetching and storing HIP objects
;;;  via SOH database access routines.
;;;

(in-package "PT")

(defun db-fetch-type (dbtypedesc)
  (let* ((dbtype (first dbtypedesc))
	 (qual (second dbtypedesc))
	 (objects (db-fetch-objects dbtype qual)))
    (mapcar #'store objects)))
	 
(defun db-open ()
  "Open the HIP database"
  (unless *hip-db-open*
	  (setf *hip-db-open* (initdb *hip-db*)))
  *hip-db-open*)

(defun db-init ()
  (mapcar #'db-fetch-type *db-types*))

(defun db-close ()
  "Close the HIP database"
  (when *hip-db-open*
	(save-object-cache)
	(closedb)
	(setf *hip-db-open* nil))
  t)

(defun db-fetch-objects (class where)
  "Retrieve members of class satisfying the given restriction"
  (let ((class (if (symbolp class) (find-class class) class)))
    (mfetch-dbobject-where class where 'clos::deferred-update 'no-error)))

(defmethod db-fetch-object ((self dbobject))
  "Retrieve an object's contents from the database"
  (get-dbobject self))

(defmethod db-store-object ((self dbobject))
  "Store an object to the database"
  (store-dbobject self))

(defmethod db-unstore-object ((self dbobject))
  "Remove an object from the database"
  (delete-dbobject self))
