;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: johnb $
;;; $Source: /pic2/picasso/new/widgets/graphic/RCS/rover-widget.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 1991/07/19 18:34:33 $
;;;

(in-package "PT")

(defclass rover-widget (widget)
  ((scale
    :initarg :scale 
    :initform nil
    :type cons
    :accessor scale)
   (old-coords
    :initarg :old-coords 
    :initform nil
    :type cons)
   (cursor
    :initform (make-cursor :bitmap-file "single_dot.cursor" 
			   :mask-file "single_dot_mask.cursor"))
   (gc-spec :initform '(gc-res (:function 10 :line-width 3 :cap-style :round)))
   (event-mask 
    :initform '(:button-press :button-release :pointer-motion :enter-window 
				:leave-window :exposure))))

(defun make-rover-widget (&rest keys)
  (apply #'make-instance 'rover-widget :allow-other-keys t keys))

(defmethod new-instance ((self rover-widget) &rest args)
  (declare (ignore args))
  (call-next-method)
  (make-image :name "quad-arrow" :file "quad-arrow.bitmap"))

(defhandler select ((self rover-widget) &key x y &allow-other-keys  
		    &aux scale sx sy
		    &default :button-press)
  (invert self)
  (repaint self)
  (setq scale (scale self))
  (setq sx (car scale)
	sy (cdr scale))
  (setf (slot-value self 'value) nil)
  (setf (value self)
	(cons
	 (/ (- x sx) sx)
	 (/ (- sy y) sy))))

(defhandler deselect ((self rover-widget) &rest event
		      &default :button-release)
  (declare (ignore event))
  (invert self)
  (repaint self))

(defhandler move ((self rover-widget) &key x y &allow-other-keys 
		  &aux scale sx sy ocds gc
		  &default :pointer-motion)
  (setq scale (scale self)
	gc (gc-res self))
  (setq sx (car scale)
	sy (cdr scale))
  
  ;;	Erase old indicator
  (when (setq ocds (slot-value self 'old-coords))
	(xlib:draw-line (res self) gc sx sy (car ocds) (cdr ocds)))
  
  ;;	Draw new indicator
  (setf (slot-value self 'old-coords)
	(cons x y))
  (xlib:draw-line (res self) gc sx sy x y))

(defhandler activate ((self rover-widget) &rest event
		      &default :enter-window)
  (declare (ignore event))
  (clear self)
  (setf (xlib:gcontext-function (gc-res self)) 10))

(defhandler deactivate ((self rover-widget) &rest event
			&default :leave-window)
  (declare (ignore event))
  (setf (slot-value self 'old-coords) nil)
  (setf (xlib:gcontext-function (gc-res self)) 2)
  (repaint self))

(defmethod resize-window-handler ((self rover-widget))
  (call-next-method)
  (setf (scale self)
	(cons
	 (round (/ (width self) 2))
	 (round (/ (height self) 2)))))

(defmethod do-repaint ((self rover-widget) 
		       &key 
		       &allow-other-keys
		       &aux res gc ocds scale)
  (call-next-method)
  
  (setq res (res self)
	gc (gc-res self))
  
  ;;	Initialize scale if necessary
  (unless (setq scale (scale self))
	  (setf (scale self)
		(setq scale
		      (cons 
		       (round (/ (width self) 2))
		       (round (/ (height self) 2))))))
  
  ;;	Repaint indicator
  (if (setq ocds (slot-value self 'old-coords)) 
      (progn
       (setf (xlib:gcontext-function gc) 10)
       (xlib:draw-line res gc (car scale) (cdr scale) (car ocds) (cdr ocds)))
      (progn
       (setf (xlib:gcontext-function gc) 2)
       (xlib:put-image res gc (res (get-image "quad-arrow")) 
		       :x (- (car scale) 8) :y (- (cdr scale) 8)
		       :bitmap-p t))))
