(in-package "PT")

;; code for C foreign function version
#|
(defvar *map-float-loaded* nil)
(defvar *map-float-data* (make-array 1000
				     :element-type 'double-float
				     :initial-element 0.0d0))

(unless *map-float-loaded*
  (load "map-float.o")
  (setq *map-float-loaded* t))

(defun map-float (in rv mx my bx by)
  (let* ((count (length in)))
	; (declare (optimize (speed 3) (safety 0)))
	(if (null rv)
	    (setq rv (make-array count
				 :element-type 'fixnum :initial-element 0)))
	(if (typep in '(simple-array double-float))
	    (map-float-internal in rv (truncate count 2) mx bx my by)
	    (progn
	     (dotimes (j count)
		      (setf (aref *map-float-data* j) 
			    (coerce (aref in j) 'double-float)))
	     (map-float-internal *map-float-data* rv
				 (truncate count 2) mx bx my by)))
	rv))

(defforeign 'map-float-internal 
  :entry-point "_MapFloatArray"
  :return-type :void)

|#

(defun map-float (in rv mx my bx by)
  (let* ((count (length in))
	 (limit (truncate count 2))
	 (i 0))
	(if (null rv)
	    (setq rv (make-array count
				 :element-type 'fixnum :initial-element 0)))
	(dotimes (j limit)
		 (setf (aref rv i) (truncate (+ bx (* mx (aref in i)))))
		 (incf i)
		 (setf (aref rv i) (truncate (+ by (* my (aref in i)))))
		 (incf i))
	rv))
