;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/check-radio/RCS/check-group.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:07:04 $
;;;

(in-package "PT")

;;;
;;;  A check-group is a type of button group used to implement check boxes.
;;;  See the documentation on button-group for details.
;;;

(defclass check-group (button-group)
  ((name :initform "Check-Box Group") 
   (active-image 
    :initform (make-image :name "check-select" :file "check-true.bitmap"))
   (inactive-image 
    :initform (make-image :name "check-deselect" :file "check-false.bitmap"))))

(defun make-check-group (&rest keys)
  (apply #'make-instance 'check-group :allow-other-keys t keys))
