;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/check-radio/RCS/check-button.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:07:04 $
;;;

(in-package "PT")

;;;
;;; Check-buttons display a small box that is either checked or not, 
;;  and buttoning them toggles their state.
;;;

(defclass check-button (widget)
  ((value 
    :initarg :value  
    :initform nil
    :type atom
    ;; :reader value
    )
   (border-width :initform 0)
   (select-image
    :initarg :select-image  
    :initform nil
    :type image
    :reader select-image
    :allocation :class)
   (deselect-image
    :initarg :deselect-image  
    :initform nil
    :type image
    :reader deselect-image
    :allocation :class)
   (check-func 
    :initform nil
    :accessor check-func
    :type function)
   (base-width
    :initform 25)
   (base-height 
    :initform 20)
   (event-mask :initform '(:exposure :button-press))))

(defun make-check-button (&rest keys)
  (apply #'make-instance 'check-button :allow-other-keys t keys))

(defmethod value ((self check-button) &key  &allow-other-keys)
  (slot-value self 'value))

(defmethod (setf value) (val (self check-button))
  (unless (eq val (slot-value self 'value))
	  (setf (slot-value self 'value) val)
	  (repaint self)))

(defmethod new-instance ((self check-button) &rest args)
  (declare (ignore args))
  (call-next-method)
  (unless (select-image self)
	  (setf (slot-value self 'select-image) 
		(make-image :name "check-select" :file "check-true.bitmap")
		(slot-value self 'deselect-image)
		(make-image :name "check-deselect" :file "check-false.bitmap")))
  self)

;;;
;;; event-handler for check-button
;;;

(defhandler select ((self check-button) &rest args
		    &default :button-press)
  (declare (ignore args))
  (when (not (dimmed self))
	(setf (value self) (not (value self))))
  (when (check-func self) (funcall (check-func self) self (value self)))
  )

(defmethod do-repaint ((self check-button)
		       &key 
		       &allow-other-keys)
  (put (if (value self)
	   (select-image self)
	   (deselect-image self))
       :window self :gc (gc-res self) 
       :width (width self) :height (height self) :bitmap-p t))
