;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/button/RCS/pop-button.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:06:58 $
;;;

(in-package "PT")

;;;
;;;	A pop-button is like any other button except that it pops up a menu
;;;	pane when selected which has user-specified behavior.  By default,
;;;	the menu-items just set the value of the button to their value.
;;; 	Pop buttons take a list of strings (:items '("hello" "there" . . .))
;;;	and a font along with all the other button arguments.  
;;;	Optionally, the :items may be a list of lists where each list has
;;;	an object and an expression to eval (code for the menu-entries)
;;;	For example
;;;		:items '(("hello" '(print "This is Great"))
;;;			 ("good-bye" `(print ',val))
;;;			 "welcome"
;;;			 ("cancel" nil))
;;;	

(defclass pop-button (button)
  ((menu :initarg :menu  :initform nil :type menu-pane :accessor menu)
   (gc-spec :initform '((gc-res "default")
			(gc-black (:line-width 2 :foreground "black"
					       :cap-style :projecting))))
   (border-width :initform 0)
   (gc-black :initform nil :type vector :reader gc-black)
   (items-font :initarg nil :accessor items-font)
   (background :initform :parent-relative)
   (event-mask :initform '(:exposure :button-press :button-release))))

(defun make-pop-button (&rest args &aux (pbtype 'pop-button))
  (when (getf args :gray)
	(remf args :gray)
	(setq pbtype 'gray-pop-button))
  (apply #'make-instance pbtype :allow-other-keys t args))

(defmethod (setf release-func) (val (self pop-button))
  (declare (ignore val))
  (warn "Can't set the release-func of a pop-button"))

(defmethod (setf items) (items (self pop-button))
  (destroy (menu self))
  (let ((mp (make-menu-pane :tearable nil))
	(items-font (items-font self)))
    (setf (menu self) mp)
    (setf (lexical-parent mp) #!po)
    (dolist (val items)
	    (if (atom val) 
		(make-menu-entry :parent mp :center val 
				 :font items-font
				 :code `(setf (value ',self) ,val))
	      (make-menu-entry :parent mp :center (car val) 
			       :font items-font
			       :code (cadr val))))
    (if (attached-p self) (attach mp))
    ))

(defmethod (setf inverted) (val (self pop-button) &aux gc oldval)
  (setq oldval (slot-value self 'inverted)
	gc (gc-res self))
  (setf (slot-value self 'inverted) val)
  (when (or (and (null val) oldval) (and val (null oldval)))
	(psetf (xlib:gcontext-foreground gc) (xlib:gcontext-background gc)
	       (xlib:gcontext-background gc) (xlib:gcontext-foreground gc))
	(xlib:force-gcontext-changes gc))
  (repaint self))

(defmethod new-instance ((self pop-button)
			 &key 
			 (items nil)
			 (items-font nil)
			 &allow-other-keys
			 &aux mp)
  (call-next-method)

  (setq items-font (or items-font (get-default self "items-font") (get-font)))
  (setf (items-font self) items-font)
  
  ;;	Make menu-pane
  (setf (menu self)
	(setq mp (make-menu-pane :tearable nil))) 
  (setf (lexical-parent mp) #!po)
  
  ;;	Make menu-entries
  (dolist (val items)
	  (if (atom val) 
	      (make-menu-entry :parent mp :center val 
			       :font items-font
			       :code `(setf (value ',self) ,val))
	      (make-menu-entry :parent mp :center (car val) 
			       :font items-font
			       :code (cadr val))))
  
  ;;	Set function
  (setf (press-func self)
	'(progn
	  (setf (inverted self) t)
	  (clear self)
	  (do-repaint self)
	  (flush-display (display self))
	  (activate-pop-up-menu (menu self) event)
	  (setf (inverted self) nil
		(flag self) t
		(pushed self) nil)
	  (clear self)
	  (do-repaint self))))

(defmethod do-attach ((self pop-button) &aux menu)
  (call-next-method)
  (when (setq menu (menu self))
	(attach menu)
	(setf (xlib:transient-for (res menu))
	      (res self))))

(defmethod do-detach ((self pop-button) &aux menu)
  (call-next-method)
  (when (setq menu (menu self))
	(detach menu)))

(defmethod destroy ((self pop-button) &aux menu)
  (call-next-method)
  (when (setq menu (menu self))
	(destroy menu)))

(defmethod do-repaint ((self pop-button) 
		       &key
		       &allow-other-keys
		       &aux h w)
  (draw-curved-border self (gc-black self) (gc-black self) 
		      0 0 (width self) (height self) :fill-p (inverted self))
  (call-next-method)
  (setq h (height self)
	w (width self)))
