;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/widgets/button/RCS/gray-button.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:06:58 $
;;;

(in-package "PT")

;;;
;;; gray-button class
;;;

(defclass gray-button (button)
  ((depress				;;  when set, the button looks 
    :initarg :depress
    :initform t				;;  "depressed" when selected
    :type t
    :accessor depress)
   (old-attributes			;;  keeps track of prior backgrounds
    :initarg :old-attributes
    :initform nil			;;  (before changed class)
    :type list
    :accessor old-attributes)
   (drawn-border-width
    :initarg :drawn-border-width 
    :initform 2 
    :type integer 
    :accessor drawn-border-width)
   (invert-width
    :initarg :invert-width 
    :initform 5
    :type integer
    :accessor invert-width)
   (gc-spec :initform '((gc-res "default") 
			(gc-white (:foreground "white" :background "black"))))
   (gc-white 
    :initform nil 
    :type vector
    :reader gc-white)
   (name :initform "A Gray Button" :type string)
   (border-width :initform 0 :type integer)
   (background :initform "gray75")
   (gray :initarg :gray  :initform t :type t)))

(defun make-gray-button (&rest keys &key (pop nil) &allow-other-keys)
  (remf keys :gray)
  (if pop (apply #'make-gray-pop-button keys)
      (apply #'make-instance 'gray-button :allow-other-keys t keys)))

;;;
;;;	New-instance method
;;;

(defmethod new-instance ((self gray-button) &rest args &aux bw bg)
  (declare (ignore args))
  (call-next-method)
  (setq bw (slot-value self 'border-width)
	bg (slot-value self 'background))
  (make-gray self :border-width bw :bw bw :background bg)
  self)

;;;
;;;	Setf method on gray changes classes
;;;

(defmethod (setf gray) (value (self button))
  (cond ((and (gray-button-p self) (null value))
	 (change-class self 'button))
	((gray-button-p self) nil)
	((not (null value))
	 (change-class self 'gray-button))))

;;;
;;;	Methods for changing classes
;;;

;;
;;  From button to gray-button
;;

(defmethod update-instance-for-different-class :after
	    ((old button) (new gray-button) &rest initargs)
  (declare (ignore initargs))
  (make-gray new))

;;
;;  From gray-button to button
;;

(defmethod update-instance-for-different-class :after
	    ((old gray-button) (new button) &rest initargs)
  (declare (ignore initargs))
  (make-ungray old new))

;;;
;;;	Methods to create and destroy gray borders
;;;

;;
;;  Creates gray border
;;

(defmethod make-gray ((self button)
		      &key 
		      (bw 0)
		      (border-width 2) 
		      (background "gray75"))

  ;;	Temporarily turn off repaints
  (setf (repaint-flag self) nil)

  ;;	Remember old backgrounds
  (setf (old-attributes self)
	(list (slot-value self 'background) 
	      (slot-value self 'border-width)))

  ;;	Set new border and backgrounds
  (setf (border-width self) bw)
  (setf (drawn-border-width self) border-width)
  (setf (background self) background)
  
  (setf (slot-value self 'gray) t)

  ;;	Turn repaints back on
  (setf (repaint-flag self) t))

;;
;;	Gets rid of gray-border
;;

(defmethod make-ungray ((old gray-button) self &aux obg)

  ;;	Temporarily turn off repaints
  (setf (repaint-flag self) nil)

  (setq obg (old-attributes old))
  (setf (slot-value self 'background) (first obg)
	(border-width self) (third obg))
  (setf (slot-value self 'gray) nil)

  ;;	Turn repaints back on
  (setf (repaint-flag self) t))

;;;
;;; Setf method on inverted
;;;

(defmethod (setf inverted) (value (self gray-button))
  (setf (slot-value self 'inverted) value)
  (if value
      (let* ((w (width self))
	    (h (height self))
	    (h1 (round (- (/ h 2) 10)))
	    (bw (drawn-border-width self)))
	   (when (evenp w) (setq w (1- w)))
	   (when (oddp h1) (setq h1 (1+ h1)))
	   (when (default self)
		 
		 ;;	Cover up the arrows
		 ;;	Both must be even!!!
		 (xlib:clear-area (res self) :x (+ bw 4) :y h1 :width 16 
				  :height 16 :exposures-p nil)
		 (xlib:clear-area (res self) :x (- w 23) :y h1 :width 16 
				  :height 16 :exposures-p nil))
	   ;;	Invert self
	   (if (depress self)
	       (progn
		(repaint self :clear nil)
		(let ((iw (invert-width self)))
		     (draw-inner-border self (gc-res self) (gc-white self)
					(+ iw bw) (+ iw bw) (- w iw bw 1) 
					(- h iw bw 1) :invert t)))
	       (repaint self)))
      
      (progn
       ;;  Uninvert self
       (repaint self))))

(defmethod do-repaint ((self gray-button) 
		       &key 
		       &allow-other-keys
		       &aux bw h h1 w)
  (call-next-method)
  (setq bw (drawn-border-width self))

  (setq h (height self)
	w (width self)
	h1 (round (- (/ h 2) 10)))
  (draw-3d-border self (gc-res self) (gc-white self) 0 0 w h) 
  (when (evenp w) (setq w (1- w)))
  (when (oddp h1) (setq h1 (1+ h1)))
  (when (default self)
	(xlib:put-image (res self) (gc-res self) 
			(res (make-image :name "right-arrow" 
					 :file "right_gray_arrow.bitmap"))
			:x (+ bw 4) :y h1 :width 16 :height 16
			:bitmap-p t)
	(xlib:put-image (res self) (gc-res self) 
			(res (make-image :name "left-arrow" 
					 :file "left_gray_arrow.bitmap"))
			:x (- w 20 bw) :y h1 :width 16 :height 16
			:bitmap-p t)))
