;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;
;;; $Author: chungl $
;;; $Source: /pic2/picasso/src/toolkit/resource/RCS/gif-utils.cl,v $
;;; $Revision: 1.4 $
;;; $Date: 1991/10/16 01:57:50 $
;;;

(in-package "PT")

#{(progn
   (unless *load-gif-loaded*
	   (#+allegro load 
	    #+lucid load-foreign-files *load-gif-object-location*)
	   (setq *load-gif-loaded* t))

#+allegro   (ff:DEFFOREIGN 'LOAD-GIF
		  :ENTRY-POINT "_load_gif"
		  :return-type :integer
		  :ARGUMENTS t))

#+lucid	    (def-foreign-function
	      (load-gif (:language :c)
			(:name "_load_gif")
			(:return-type :signed-32bit))
	      (filename (:simple-string))
	      (data (:simple-vector-type))
	      (red (:simple-vector-type))
	      (green (:simple-vector-type))
	      (blue (:simple-vector-type))
	      (used (:simple-vector-type)))

(defun probe-gif (filename
		 &aux 
		 width height   ; of gif raster.
		 )
  (let ((stream 
	 (open filename
	       :direction :input
	       ;; :element-type t
	       :if-does-not-exist nil)
	 ))
    ;; verify file header
    (if (null stream) (return-from probe-gif nil))
    (when (not (string= (readn stream 6)
			*gif-id*))
	  (error "not a GIF file.")
	  )

    ;; get picture size.
    (setq width (read-int stream))
    (setq height (read-int stream))
    (close stream)
    (values width height)
    ))

(defun read-int (stream)
  (+ (char-code (read-char stream))
     (* 256 (char-code (read-char stream)))))

(defun readn (stream n &aux (str ""))
  (dotimes (ignored n)
	   (setq str (concatenate 'string
				  str (string (read-char stream)))))
  str)

;; ce is 0 to 255.  sd is number of significant digits.
;; converts into a float from 0 to 1.0 of sd signf. digits. 
(defun convert-color-element (ce sd &aux e)
  (setf e (expt 10 sd))
  (float (/ (truncate (* e (/ ce 255))) e)))

;;
;; allocate colors necessary to display the image in data.
;; return the number of bits that had to be stripped or nil if
;; color allocation failed.
;; modify data to reflect the pixels values returned by X.
;;
(defun allocate-colors (colormap red green blue used num-colors)
  (let ((pixel-table (make-array '(256) :element-type 'xlib:pixel))
	(sd 3)				;significant digits for colors.
	color)
    (dotimes (i num-colors t)
	     (when (not (= (aref used i) 0))
		   (setq color
			 (xlib:make-color
			  :red (convert-color-element (aref red i) sd)
			  :green (convert-color-element (aref green i) sd)
			  :blue (convert-color-element (aref blue i) sd)))
		   (setf (aref pixel-table i)
			 (xlib:alloc-color colormap color))
		   ))
    pixel-table))

(defun fix-pixel-values (data pt red green blue &aux d)
  (cond ((true-color-p)
	 (dotimes (i (/ (length data) 4))
		  (setf d (aref data (* 4 i)))
		  (setf (aref data (+ 1 (* i 4))) (aref red d)
			(aref data (+ 2 (* i 4))) (aref green d)
			(aref data (+ 3 (* i 4))) (aref blue d)))
	 data)
	(t 
	 (dotimes (i (length data))
		  (setf d (aref data i))
		  (setf (aref data i)
			(aref pt d)))
	 data)))

(defun true-color-p ()
  (eq ':true-color
      (xlib:visual-info-class (xlib:screen-root-visual-info 
			       (res (default-screen))))))


