;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/resource/defaults.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:03:13 $
;;;

(in-package "PT")


;;;
;;;	Loads event defaults from file(s)
;;;
(defun load-defaults (&key (erase-old t))
  (load-event-maps :erase-old erase-old))

;;;
;;;	Gets default from resource-database (loaded in automatically)
;;;	specified by OBJ and ATTRIBUTE.
;;;	OBJ designates a class of windows (eg. "text-widget") and is of type:
;;;	(member '(pcl::object pcl::class stringable nil))
;;;	If nil, OBJ matches any top-level class in the data-base.
;;;	ATTRIBUTE is either a single field (stringable) or a list of fields.
;;;
;;;	For example:
;;;	(get-default <a-button> "background")
;;;	(get-default "button" "foreground")
;;;	(get-default "my-tool" '("frame1" "form3" "entry-widget5"))
;;;		     
;;;	See CLX doc on get-resource for more info
;;;
(defun get-default (obj attribute 
			&key (bw-p nil bw-spec) default-to
			&aux field att-fields)
  (cond ((typep obj 'standard-object)
	 (setq obj (string-downcase (class-name (class-of obj))))
	 (if (null bw-spec)
	     (if (window-p obj)
		 (setq bw-p (black-and-white-display-p obj))
		 (setq bw-p (black-and-white-display-p)))))
	((null obj) 
	 (if (null bw-spec)
	     (setq bw-p (black-and-white-display-p))))
	((typep obj 'clos::class)
	 (setq obj (string-downcase (class-name obj)))
	 (if (null bw-spec)
	     (setq bw-p (black-and-white-display-p))))
	(t
	 (setq obj (string-downcase obj))
	 (if (null bw-spec)
	     (setq bw-p (black-and-white-display-p)))))
  (setq attribute (mystringify attribute))
  (when bw-p
	(if (setq field 
		  (get-default 
		   obj 
		   (if (listp attribute) 
		       (append attribute (list *black-and-white-field*))
		       (list attribute *black-and-white-field*))
		   :bw-p nil))
	    (return-from get-default field)
	    (if bw-spec
		(return-from get-default default-to))))
  (cond ((listp attribute)
	 (setq obj (cons obj (butlast attribute)))
	 (setq field t)
	 (setq attribute (car (last attribute))))
	(t
	 (setq obj (list obj))))
  (cond (field
	 (setq att-fields
	       (cons *widget-class*
		     (make-list (length attribute) 
				:initial-element "blah"))))
	(t
	 (setq att-fields (cons *widget-class* nil))
	 (setq field *attribute-class*)))
  (or
   (xlib:get-resource *resource-database* attribute field
		      obj
		      att-fields)
   default-to))

(defun mystringify (obj)
  (cond ((stringp obj) obj)
	((null obj) nil)
	((atom obj)
	 (string-downcase obj))
	(t
	 (mapcar #'mystringify obj))))

