;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/label/left-label.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:03:03 $
;;;

(in-package "PT")

;; label goes to left of field

(defmethod label-init ((label (eql :left)) self &aux lab gc atts)
  (call-next-method)
  (setq lab (label self)) 
  (when (stringp lab) 
	(setq atts (slot-value self 'label-attributes))
	(unless (getf atts :foreground)
		(setf (getf atts :foreground) "black"))
	(unless (getf atts :background)
		(setf (getf atts :background) "white"))
	(unless (getf atts :font)
		(setf (getf atts :font) "8x13"))
	(setf (slot-value self 'intern-label-gc)
	      (setq gc (make-shared-gc (parent self) atts)))
	(setf (label-x self) (- 0 (text-width lab :gc gc) 5)
	      (label-y self) 0)))

(defmethod label-notify-change ((label (eql :left)) self &aux lab gc)
  (setq lab (label self)) 
  (when (stringp lab) 
	(setq gc (slot-value self 'intern-label-gc))
	(setf (label-x self) (- 0 (text-width lab :gc gc) 5)
	      (label-y self) 0)))

(defmethod label-clear ((label (eql :left)) self &aux sup)
  (setq sup (parent self))
  (clear-region sup 
		(+ (repaint-x sup) (x-offset self) (label-x self)) 
		(+ (repaint-y sup) (y-offset self) (label-y self))
		(abs (label-x self))
		(height self)))

(defmethod label-repaint ((label (eql :left)) self &aux sup atts 
			  hjust vjust)
  (setq sup (parent self))
  (setq atts (label-attributes self)) 
  (setq hjust (or (getf atts :horiz-just) :left) 
	vjust (or (getf atts :vert-just) :center))
  (put (label self) :window sup :gc (slot-value self 'intern-label-gc) 
       :x (+ (repaint-x sup) (x-offset self) (label-x self))
       :y (+ (repaint-y sup) (y-offset self) (label-y self))
       :height (height self)
       :horiz-just hjust :vert-just vjust))

(defmethod label-left-pad ((label (eql :left)) self &rest args)
  (declare (ignore args))
  (- (label-x self)))

(defmethod label-bottom-pad ((label (eql :left)) self 
			     &key height &allow-other-keys)
  (if (null height)
      (setq height (height self)))
  (max 0 (- (label-y self) height)))

(defmethod label-pad ((label (eql :left)) self &rest args)
  (declare (ignore args))
  (values (- (label-x self)) 0 0 (max 0 (- (label-y self) (height self)))))
