;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/label/bottom-label.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:03:03 $
;;;

(in-package "PT")

;; label goes to bottom of field

(defmethod label-clear ((label (eql :bottom)) self &aux sup)
  (setq sup (parent self))
  (clear-region sup 
		(+ (repaint-x sup) (x-offset self) (label-x self)) 
		(+ (repaint-y sup) (y-offset self) (label-y self))
		(abs (label-x self))
		(height self)))

(defmethod label-repaint ((label (eql :bottom)) self &aux sup lab 
			  atts hjust vjust)
  (setq sup (parent self))
  (setq lab (label self)) 
  (setq atts (label-attributes self))
  (setq hjust (or (getf atts :horiz-just) :center)
	vjust (or (getf atts :vert-just) :top))
  (put (label self) :window sup :gc (slot-value self 'intern-label-gc) 
       :x (+ (repaint-x sup) (x-offset self) (label-x self))
       :y (+ (repaint-y sup) (y-offset self) (height self) (label-y self))
       :width (width self)
       :ignore-bounds t
       :horiz-just hjust :vert-just vjust))

(defmethod label-left-pad ((label (eql :bottom)) self &rest args)
  (declare (ignore args))
  (- (label-x self)))

(defmethod label-bottom-pad ((label (eql :bottom)) self &rest args)
  (declare (ignore args))
  (+ (label-y self)
     (font-height nil (slot-value self 'intern-label-gc))))

(defmethod label-pad ((label (eql :bottom)) self &rest args)
  (declare (ignore args))
  (values (- (label-x self)) 0 0 
	  (+ (label-y self)
	     (font-height nil (slot-value self 'intern-label-gc)))))

