;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/gm/sw-gm.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:02:51 $
;;;

(in-package "PT")

;;;  null-gm is a simple geometry manager which merely handles resizing 
;;;  children to their base sizes.

(defmethod gm-calculate-min-size ((gm (eql 'sw-gm)) self)
  (setf (min-size self)
	(list (slot-value self 'base-width) (slot-value self 'base-height))))


(defmethod gm-repack ((gm (eql 'sw-gm)) self &aux ch)
  (when (setq ch (car (children self)))
	(let ((width (width self))
	      (height (height self))
	      (bw (base-width ch))
	      (bh (base-height ch))
	      (wi (width-increment ch))
	      (hi (height-increment ch))
	      (temp1 nil)
	      (temp2 nil)
	      (w-pad nil)
	      (h-pad nil))
	     (multiple-value-setq (temp1 temp2 w-pad h-pad)
				  (region-offset 
				   ch :width bw :height bh))
	     (apply #'reshape
		    ch
		    (actual-region ch
				   :x 0 :y 0
				   :width (if (zerop wi)
					      (+ (max bw (width ch) w-pad))
					      (max (+ bw w-pad) width))
				   :height (if (zerop hi)
					       (+ (max bh (height ch) h-pad))
					       (max (+ bh h-pad) height)))))))

