;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/gm/stacked-gm.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:02:51 $
;;;

(in-package "PT")

;;;
;;;	Stacked-gm packs as many windows in a row that can fit, then
;;;	overflows into the next row.  This process is continued until either
;;;	there is no more space for another row or all windows have been
;;;	packed in.
;;;	Geom-specs are ignored.  The gm-data, however, is a list of the 
;;;	following form:  (<inter-row-gap> <inter-column-gap> <max-height>)
;;;	<max-height> is optional.
;;;

(defmethod gm-initialize ((gm (eql 'stacked-gm)) self)
  (if (consp (gm-data self))
      (cond ((= 1 (length (gm-data self)))
	     (setf (gm-data self) (list (car (gm-data self)) 0)))
	    ((< 3 (length (gm-data self)))
	     (setf (cdddr (gm-data self)) nil)))
      (setf (gm-data self) '(0 0))))

(defmethod gm-add-child ((gm (eql 'stacked-gm)) self child)
  (setf (slot-value self 'children)
	(push child (slot-value self 'children)))
  (if (and (managed-p child) (repack-flag self))
      (do-repack self)))

(defmethod gm-resize-hint-changed ((gm (eql 'stacked-gm)) self child)
  ;;  There is no reason to adjust anything except the min-size which is
  ;;  handled by macros
  (declare (ignore self child))
  t)

(defmethod gm-spec-changed ((gm (eql 'stacked-gm)) self child)
  ;;  Ignored
  (declare (ignore self child))
  t)

(defmethod gm-calculate-min-size ((gm (eql 'stacked-gm)) self &aux ch)
  ;;  min-size is pretty much useless. . .
  (setf (min-size self)
	(if (setq ch (car (children self)))
	    (base-size ch)
	    '(1 1))))

(defun sgm-size (win &aux gs)
  (if (setq gs (geom-spec win))
      (values (car gs) (cadr gs))
      (values (max (base-width win) (width win))
	      (max (base-height win) (height win)))))

(defmethod gm-repack ((gm (eql 'stacked-gm)) self 
		      &aux gmd avail-width avail-height total-width
		      total-height x y x-pad y-pad next-ch base-y children 
		      max-height bw cw ct lp rp tp bp nw nh)
  (setq gmd (gm-data self))
  (setq x-pad (first gmd)
	y-pad (second gmd)
	max-height (third gmd)
	total-width (width self)
	total-height (height self))
  (setq avail-width (- total-width x-pad)
	x x-pad
	y y-pad
	base-y y-pad)
  (setq children (reverse (children self)))
  (when (setq bw (car children))
	(unless max-height (setq max-height (virtual-height bw)))
	(setq bw (border-width bw)))
  (setq avail-height max-height)
  (do* ((chl (managed-of children) (cdr chl))
	(ch (car chl) (car chl))) 
       ((endp chl)) 
       (multiple-value-setq (cw ct) (sgm-size ch))
       (multiple-value-setq (lp tp rp bp)
			    (region-offset ch :x x :y y :width cw :height ct))
;       (setq cw (- cw rp) ct (- ct bp))
       (reshape ch (+ x lp) (+ y tp) (- cw rp) (- ct bp))
       (setq avail-height (- avail-height ct y-pad))
       (when (setq next-ch (cadr chl))
	     (multiple-value-setq (nw nh) (sgm-size next-ch))
	     (if (>= avail-height nh)
		 (setq y (+ y ct y-pad))
		 (progn
		  (setq y base-y
			avail-height max-height
			x (+ x cw x-pad))
		  (setq avail-width (- avail-width cw x-pad))))
	     (when (< avail-width (+ nw x-pad))
		   (setq avail-width total-width
			 x x-pad
			 base-y (+ base-y max-height y-pad)
			 avail-height max-height)
		   (setq y base-y)))))
