;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/gm/null-gm.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:02:51 $
;;;

(in-package "PT")

;;;  null-gm is a simple geometry manager which merely handles resizing 
;;;  children to their base sizes.

(defmethod gm-initialize ((gm t) self)
  (setf (slot-value self 'gm-data) nil))

(defmethod gm-add-child ((gm t) self child)
  (push child (slot-value self 'children))
  (if (managed-p child)
      (do-repack self)))

(defmethod gm-delete-child ((gm t) self child)
  (setf (slot-value self 'children) (delete child (children self)))
  (if (managed-p child)
      (do-repack self)))

(defmethod gm-resize-hint-changed ((gm t) self child)
  (if (managed-p child)
      (do-repack self)))

(defmethod gm-status-changed ((gm t) self child)
  (if (not (x-window-p child))
      ;; Don't have to do anything if child is x-window -- server will call us
      ;; Child is not x-window. If child is newly expose, just repaint it,
      ;; otherwise, repaint ourselves to fill in hole.
      (if (exposed-p child)
	  (repaint child)
	  (let* ((x (x-offset child))
		 (y (y-offset child))
		 (bd (border-width child))
		 (bdw nil)
		 (bdh nil)
		 (w nil)
		 (h nil))
		(if (listp bd)
		    (setq bdw (+ (first bd) (third bd))
			  bdh (+ (second bd) (fourth bd)))
		    (setq bdw 
			  (setq bdh (+ bd bd))))
		(setq w (+ (width child) bdw)
		      h (+ (height child) bdh))
		(repaint-region self x y w h)))))

(defmethod gm-spec-changed ((gm t) self child)
  (declare (ignore self child))
   t)

(defmethod gm-changed ((gm t) self (old-gm t))
  (unless (eq gm old-gm)
	  (gm-initialize gm self)
	  (do-repack self)))

(defmethod gm-data-changed ((gm t) self old-data)
  (declare (ignore self old-data))
  t)

(defmethod gm-calculate-min-size ((gm t) self)
  (let* ((max-w 0)
	 (max-h 0))
	(dolist (ch (managed-of (children self)))
		(setq max-w (max max-w (+ (x-offset ch) 
					  (if (zerop (base-width ch))
					      (width ch)
					      (base-width ch)))))
		(setq max-h (max max-h (+ (y-offset ch) 
					  (if (zerop (base-height ch))
					      (height ch)
					      (base-height ch))))))
	(setf (min-size self) (list max-w max-h))))


(defmethod gm-repack ((gm t) self)
  (dolist (ch (managed-of (children self)))
	  (let ((bw (base-width ch))
		(bh (base-height ch))
		(wi (width-increment ch))
		(hi (height-increment ch))
		(reg nil))
		(setq reg
		      (actual-region
		       ch 
		       :width 
		       (if (zerop wi) bw 
			   (max (virtual-width ch) (base-width ch)))
		       :height (if (zerop hi) bh 
				   (max (virtual-height ch) 
					(base-height ch)))))
	       (resize ch (third reg) (fourth reg))))
  (repaint self))

