;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/gm/linear-gm.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:02:51 $
;;;

(in-package "PT")


;;;  linear gm resizes children in a manner that keeps a constant sized
;;;  border around them in the parent.  The border is determined by the 
;;;  x and y offsets (left and top border) and by the geom spec (which is
;;;  a list with the total width and height borders).  By default, the 
;;;  children maintain a total border equal to the border size when they
;;;  are added to the collection.  This can be changed by providing or 
;;;  setting the geom-spec.

(defmethod gm-add-child ((gm (eql 'linear-gm)) self child)
  (let* ((gs (parse-linear-geom-spec self child))
	 (w-diff (car gs))
	 (h-diff (cadr gs)))
	(push child (children self))
	(resize child (- (width self) (x-offset child) w-diff)
	              (- (height self) (y-offset child) h-diff))
	(if (exposed-p child) (repaint child))))

(defmethod gm-delete-child ((gm (eql 'linear-gm)) self child)
  (setf (slot-value self 'children) (delete child (children self)))
  (if (and (exposed-p child) (not (x-window-p child)))
      (repaint-region self (x-offset child) (y-offset child) (width child)
		      (height child))))

(defmethod gm-resize-hint-changed ((gm (eql 'linear-gm)) self child)
  ;;  There is no reason to adjust anything except the min-size which is
  ;;  handled by macros
  (declare (ignore self child))
  t)

(defmethod gm-spec-changed ((gm (eql 'linear-gm)) self child)
  ;;  This could be optimized to just change and repaint as needed, but
  ;;  that can be done when this becomes a bottleneck
  (if (managed-p child)
      (do-repack self)))


(defmethod gm-calculate-min-size ((gm (eql 'linear-gm)) self)
  (let* ((max-w 0)
	 (gs nil)
	 (max-h 0))
	(dolist (ch (managed-of (children self)))
		(setq gs (parse-linear-geom-spec self ch))
		(setq max-w (max max-w (+ (if (zerop (base-width ch))
					      (width ch)
					      (base-width ch))
					  (car gs))))
		(setq max-h (max max-h (+ (if (zerop (base-height ch))
					      (height ch)
					      (base-height ch))
					  (cadr gs)))))
	(setf (min-size self) (list max-w max-h))))

(defmethod gm-repack ((gm (eql 'linear-gm)) self)
  (let ((nh (height self))
	(nw (width self)))
       (dolist (ch (children self))
	       (let* ((gs (parse-linear-geom-spec self ch))
		      (w-diff (car gs))
		      (h-diff (cadr gs)))
		     (resize ch (- nw (x-offset ch) w-diff)
			        (- nh (y-offset ch) h-diff))))
       (repaint self)))

(defun parse-linear-geom-spec (parent child)
  (let ((gs (geom-spec child)))
       (cond ((and (consp gs) (eq (car gs) *linear-gm-magic-atom*))
	      (cdr gs))
	     ((and (consp gs) (= (length gs) 2) (integerp (car gs))
		   (integerp (cadr gs)))
	      ;; Note to Steve::  You can put any other sanity checks here
	      (setf (slot-value child 'geom-spec) 
		    (cons *linear-gm-magic-atom* gs))
	      gs)
	     (t (let* ((p-w (width parent))
		       (p-h (height parent))
		       (ch-w (min (- p-w (x-offset child))
				  (max (base-width child) (width child))))
		       (ch-h (min (- p-h (y-offset child))
				  (max (base-height child) (height child))))
		       (w-diff (- p-w ch-w))
		       (h-diff (- p-h ch-h)))
		      (setf (slot-value child 'geom-spec)
			    (list *linear-gm-magic-atom* w-diff h-diff))
		      (cdr (geom-spec child)))))))
