;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/etc/clos.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:02:49 $
;;;

;;; This file contains modifications to CLOS used by picasso.
;;; Among these is a modification to the parse-defmethod function,
;;; called by the defmethod macro, to add profiling code.  The code
;;; keeps track of the number of calls to a method and the approximate
;;; time spent in the method.  The resolution of this clock is about 20
;;; milleseconds.  Note that this profiling data applies only to method
;;; calls, not function calls.
;;;
;;; The basic interface to the profiler is simple.  :profiler should be
;;; on the *features* list to enable the profiling code to be generated.
;;; The basic overhead of this code with profiling off is very low (two
;;; compares with global variable and a couple of surrounding prog
;;; structures), and so shouldn't present a problem for debugging use.
;;; All modules to be profiled must be recompiled with :profiler on
;;; the features list.  Once this is done, generation of profiling
;;; statistics can be turned on and off using the prof:*profile*
;;; global variable;  if this variable is non-nil, statistics are gathered,
;;; otherwise they are not.  This mechanism allows fine tuned gathering of
;;; profiling data under programmer control.  For example, to figure out
;;; how time is spent inside the "foo" method, set prof:*profile* to "t"
;;; as the first line of the method, and back to it's original value at
;;; the exit point of the method.
;;;
;;; The report generating facilities of the profiler are modeled after
;;; the allegro profiler. The most useful functions are:
;;;	method-call-report (&key number-to-report sort-by)
;;;	method-call-clear ()
;;; The first of these functions produces a sorted list showing the
;;; number of times a method is called, the total time spent in a method,
;;; and the average time spent in a method. The number-to-report keyword
;;; controls how many records are printed (default is all), the keyword
;;; sort-by controls the ordering of the sorting and should be one of
;;; the values :total-time :average-time :calls (default is :total-time).
;;; If given :total-time, the function sorts the list by the total time
;;; spent in the method, if given :average-time, the function sorts the
;;; list by the average time spent in the method, and if given :calls,
;;; the function sorts the list by the number of calls to the method.
;;;
;;; The method-call-clear function simply resets the data structures
;;; holding the profiling statistics.  It is used to seperate profiling
;;; runs.  Note that unlike the allegro profiler, this function is not 
;;; automatically called after method-call-report.
;;;

(in-package "PT")

;; picasso mixin class.  all objects in picasso are pmcs.  
;; in effect this causes the new-instance method of an object to be called
;; at creation time.

(defclass pmc () ())

(defmethod initialize-instance :after ((self pmc) &rest init-plist)
  (apply #'new-instance self init-plist))

(defmethod new-instance ((self pmc) &key &allow-other-keys)
  t)

;;;;  This section can be removed when AllegroCL 4.1 is used

(in-package "CLOS")

#+allegro
(def-function-spec-handler method (spec op func)
  (multiple-value-bind (name qualifiers specializers)
      (parse-defmethod (cdr spec))
    (let* ((gf (fboundp name))
           (method (and gf
                        (find-method gf
                                     qualifiers
;;;;;;;;;;;;;;;;;;;;;;;The next form was: (mapcar #'find-class specializers)
                                     (parse-specializers specializers)
                                     nil))))
      (case op
        (:validate (not (null gf)))
        ((:setfable fboundp)
         (and method (method-function method)))
        (fmakunbound (remove-method gf method))
        (boundp t)
        (block (error "~s may not be defined with defun" spec))
        (setf (setf (slot-value method 'function) func)
          (invalidate-discriminating-function gf)
          func)))))

