;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/borders/frame-border.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:02:43 $
;;;

(in-package "PT")

;; a frame border looks something like a picture frame

(defmethod border-init ((border (eql :frame)) self &aux sup atts gc info) 
  (setq sup (parent self))
  (setf (xlib:drawable-border-width (res self)) 0)
  (setq atts (border-attributes self))
  (setq info (getf atts :border-width))
  (when (setq gc (getf atts :background))
	(setq gc (make-shared-gc sup (list :foreground gc))))
  (setf (slot-value self 'intern-border-gcs) 
	(list (make-shared-gc sup '(:background "white" :foreground "black"))
	      (make-shared-gc sup '(:foreground "white"))
	      gc))
  (setf (slot-value self 'border-width) 
	(if (valid-border-p info)
	    info
	    7)))

(defmethod border-repaint ((border (eql :frame)) self &aux gcs bw w h sup)
  (setq gcs (slot-value self 'intern-border-gcs)
	bw (slot-value self 'border-width)
	sup (parent self))
  (if (listp bw) 
      (setq w (car bw) h (cadr bw))
      (setq w bw h bw))
  (draw-outer-border self (car gcs) (cadr gcs) :x-width w :y-width h 
		     :fill-gc (third gcs)))

(defmethod border-clear ((border (eql :frame)) self &aux bw x y w h sup)
  (setq bw (border-width self)
	sup (parent self))
  (if (listp bw) 
      (setq x (car bw) y (cadr bw) w (third bw) h (fourth bw))
      (setq x bw y bw w bw h bw))
  (clear-region (parent self) 
		(+ (repaint-x sup) (x-offset self) (- x))
		(+ (repaint-y sup) (y-offset self) (- y))
		(+ (width self) x w 2)
		(+ (height self) y h 2)))
