;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/borders/black-frame-border.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:02:43 $
;;;

(in-package "PT")

;; a box border is simply a black rectangle around the window

(defmethod border-init ((border (eql :black-frame)) self)
  (setf (slot-value self 'intern-border-gcs)
	(make-shared-gc (parent self) "default")
	(slot-value self 'border-width) 7))

(defmethod border-repaint ((border (eql :black-frame)) self 
			   &aux bw lbw tbw rbw bbw rx ry x y w h sup)
  (setq sup (parent self)
	bw (border-width self))
  (if (listp bw)
      (setq lbw (first bw)
	    tbw (second bw)
	    rbw (third bw)
	    bbw (fourth bw))
      (setq lbw bw
	    tbw bw
	    rbw bw
	    bbw bw))
  (setq x (x-offset self)
	y (y-offset self)
	w (width self)
	h (height self))
  (setq rx (+ (repaint-x sup) x)
	ry (+ (repaint-y sup) y))
  (xlib:draw-rectangles (res sup) (slot-value self 'intern-border-gcs)
			(list rx (- ry tbw) (+ w rbw) tbw
			      (- rx lbw) (- ry lbw) lbw (+ h tbw)
			      (+ rx w) ry rbw (+ h bbw)
			      (- rx lbw) (+ ry h) (+ w lbw) bbw) 
			t))

(defmethod border-clear ((border (eql :black-frame)) self
			 &aux bw x y w h sup)
  (setq bw (border-width self)
	sup (parent self))
  (if (listp bw)
      (setq x (car bw) y (cadr bw) w (third bw) h (fourth bw))
      (setq x bw y bw w bw h bw))
  (clear-region sup 
		(+ (repaint-x sup) (x-offset self) (- x))
		(+ (repaint-y sup) (y-offset self) (- y))
		(+ (width self) x w)
		(+ (height self) y h)))
