;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: bsmith $
;;; $Source: /pic2/picasso/new/toolkit/base/root-window.cl,v $
;;; $Revision: 1.1 $
;;; $Date: 1991/08/04 19:02:19 $
;;;

(in-package "PT")

;;;
;;; root-window class
;;;

(defclass root-window (variable-holder opaque-window collection-gadget)
  ((screen
    :initform nil
    :type screen
    :reader screen)
   (active-lexical-children
    :initform nil
    :type list
    :accessor active-lexical-children)
   (name :initform "Root Window")
   (parent :initform nil)
   (status :initform :exposed)
   (event-mask :initform '( :no-event ))
   (x-offset :initform 0)
   (y-offset :initform 0)
   (width :initform 0)
   (height :initform 0)
   (border-width :initform 0)
   (cursor :initform nil)
   (border :initform nil)
   (background :initform nil)
   (foreground :initform nil)
   (inverted-background :initform nil)
   (inverted-foreground :initform nil)
   (dimmed-background :initform nil)
   (dimmed-foreground :initform nil)
   (gm :initform 'root-gm)
   (repack-flag :initform t)))

(defun make-root-window (&rest keys)
  (apply #'make-instance 'root-window :allow-other-keys t keys))

;;;
;;; root-window initialization method
;;;

(defmethod new-instance ((self root-window)
			 &key
			 (screen nil)
			 (cursor nil)
			 &allow-other-keys)
  ;; set instance slots which require side-effects
  (setf (slot-value self 'res)
	(xlib:screen-root (res screen)))
  (setf (name self) (name self) 
	(event-mask self) (event-mask self) 
	(slot-value self 'width) (xlib:screen-width (res screen))
	(slot-value self 'height) (xlib:screen-height (res screen))
	(slot-value self 'colormap) 
	(make-colormap :window self :res (xlib:window-colormap (res self))))
  ;; test if cursor is null
  (if (not (null cursor))
      ;; set the root-window cursor
      (setf (cursor self) cursor))
  ;; add instance to hash table
  (append-window self))

;;;
;;; root-window slot setf methods
;;;

(defmethod (setf x-offset) (value (self root-window))
  (declare (ignore value))
  (warn "Can't change the x-offset of a root window"))

(defmethod (setf y-offset) (value (self root-window))
  (declare (ignore value))
  (warn "Can't change the y-offset of a root window"))

(defmethod (setf width) (value (self root-window))
  (declare (ignore value))
  (warn "Can't change the width of a root window"))

(defmethod (setf height) (value (self root-window))
  (declare (ignore value))
  (warn "Can't change the height of a root window"))

(defmethod (setf status) (value (self root-window))
  (declare (ignore value))
  (warn "Can't change the status of a root window"))

;;;
;;; root-window operation methods
;;;

(defmethod do-conceal ((self root-window) &key
	
				       &allow-other-keys)
  (warn "Can't conceal a root window")) 

(defmethod conceal-transparent ((self root-window))
  (warn "Can't conceal-transparent a root window")) 

(defmethod do-detach ((self root-window))
  (warn "Can't detach a root window"))

(defmethod do-repaint ((self root-window)
		       &key 
		       &allow-other-keys)
  nil)
