;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: smoot $
;;; $Source: /pic2/picasso/new/toolkit/base/RCS/gadget.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 1991/11/12 01:46:11 $
;;;

(in-package "PT")

;;;
;;; gadget class
;;;

(defclass gadget (window)
  ((name :initform "A Gadget")
   (status :initform :exposed)
   (font :initform *default-font-name*)
   ;; Override some defaults from parents...
   (background :initform nil)
   (dimmed-background :initform nil)
   (inverted-background :initform nil)))

(defmethod new-instance ((self gadget)
			 &key
			 &allow-other-keys)
  (call-next-method)
  ;; Propogate the res...
  (if (and (window-p (parent self))
	   (not (x-window-p (parent self))))
      (setf (slot-value self 'res) (res (parent self))))
  ;; Call appropriate value setf method for subclasses.
  (setf (value self) (slot-value self 'value))
  (setf (slot-value self 'partial-repaint-p)
        (collection-p self))
  self)

;;;
;;;  make-gadget will make the appropriate subgadget, given a value arg
;;;
(defun make-gadget (&rest args &key (children nil) 
			  &allow-other-keys)
  (if children
      (apply #'make-collection-gadget args)
      (apply #'make-instance 'synth-gadget :allow-other-keys t args)))

;;;
;;;  when changing gadget classes, the value setf methods should get called
;;;
(defmethod update-instance-for-different-class :after
    ((old gadget) (new gadget) &rest initargs)
      (declare (ignore initargs))
      (if (null-gadget-p new) 
	  (setf (value new) nil)
	  (setf (value new) (value new))))

;;; Gadget attach and detach

(defmethod do-attach ((self gadget))
  (unless (attached-p self) 
	  (setf (slot-value self 'res) (res (parent self))))
  (call-next-method))

(defmethod do-detach ((self gadget))
  (unless (x-window-p self)
	  (setf (slot-value self 'res) nil))
  (call-next-method))

;;;
;;; Gadget query methods
;;;


(defmethod repaint-y ((self gadget))
  (if (x-window-p (parent self)) 
      (slot-value self 'y-offset)
      (+ (repaint-y (parent self)) (slot-value self 'y-offset))))

(defmethod repaint-x ((self gadget))
  (if (x-window-p (parent self)) 
      (slot-value self 'x-offset)
      (+ (repaint-x (parent self)) (slot-value self 'x-offset))))

(defmethod (setf value) (value (self gadget))
  (setf (slot-value self 'value) value)
;;; (change-class self (determine-class self value))  ;;; REMOVED FOR TIME BEING
)

(defmethod determine-class ((self gadget) value)
  (determine-gadget-class value))

(defun determine-gadget-class (value)
  (cond ((null value) 'null-gadget)
	((stringp value) 'synth-gadget)
	((listp value)
	 ;; Synthetic gadget
	 (cond ((eq (car value) 'bitmap) 'bitmap-gadget)
	       ((eq (car value) 'image) 'synth-gadget)
	       ((stringp (car value)) 'synth-gadget)
	       ((null value) 'null-gadget)
	       (t (warn "gadget.determine-class, unable to determine class!~%")
		  'null-gadget)))
	((image-p value) 'synth-gadget)
	((color-p value) 'paint-gadget)
	((or (eq value :up)
	     (eq value :down)
	     (eq value :left)
	     (eq value :right)) 'arrow-gadget)
	((eq value :null) 'null-gadget)
	(t (warn "determine-gadget-class, unable to determine class!~%")
	   'null-gadget)))

;;;
;;; gadget operation methods
;;;

(defmethod warp-mouse ((self gadget)
		       &key
		       (x 0)
		       (y 0)
		       (location nil))
  ;; test if location is specified
  (if location
      (xlib:warp-pointer (res self) (first location) (second location))
      (xlib:warp-pointer (res self) x y)))

(defmethod warp-mouse-if ((self gadget)
			  &key
			  (x 0)
			  (y 0)
			  (location nil)
			  (in-window nil)
			  (in-region nil))
  ;; if region isn't specified, get in-window region
  (if (null in-region)
      (setq in-region (region in-window)))
  
  ;; if location is specified, warp mouse using location
  ;; otherwise warp mouse using x and y
  (if location
      (xlib:warp-pointer-if-inside (res self)
				   (first location) (second location)
				   (res in-window)
				   (first in-region) (second in-region)
				   (third in-region) (fourth in-region))
      (xlib:warp-pointer-if-inside (res self)
				   x y
				   (res in-window)
				   (first in-region) (second in-region)
				   (third in-region) (fourth in-region))))

;;;
;;; Definition of the null-gadget class
;;;

(defclass null-gadget (gadget) 
  ((gc-spec :initform nil)))
(defun make-null-gadget (&rest keys)
  (setf (getf keys :value) nil)
  (apply #'make-instance (cons 'null-gadget keys)))

(defmethod (setf value) ((value null) (self null-gadget)) nil)

