;;;
;;; Copyright (c) 1990 Regents of the University of California
;;; 
;;; $Author: smoot $
;;; $Source: /pic2/picasso/new/toolkit/base/RCS/collection-widget.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 1991/10/10 16:53:45 $
;;;

(in-package "PT")

;;;
;;; gadget class
;;;

(defclass collection-widget (widget collection-gadget)
  (
   ;; Set the default colors... overrides pcl inheritance of initform bug.
   (event-mask :initform '( :expose-region :exposure))
   (background :initform "white")
   (inverted-background :initform "black")
   (dimmed-background :initform "white")
   (foreground :initform "black")
   (dimmed-foreground :initform "black")
   (inverted-foreground :initform "white")))

(defun make-collection-widget (&rest keys)
  (apply #'make-instance 'collection-widget :allow-other-keys t keys))

;; Makes a collection-widget into a notifier

(defun make-notifier (cw)
  (pushnew :button-press (event-mask cw))
  (register-callback cw #'(lambda (&rest args) (declare (ignore args))
                                               (conceal cw)) 
                     :button-press))

