(in-package "VIDEO")

;; class definitions

(defclass video-disk () nil)
(defclass indexed-video-disk (video-disk) nil)

(defclass video-disk-player () nil)


;; generic function definitions

(defgeneric disk (player))
(defgeneric (setf disk) (value player))

(defgeneric disk-index (disk))
(defgeneric (setf disk-index) (value disk))

(defgeneric disk-title (disk))
(defgeneric (setf disk-title) (value disk))

(defgeneric load-disk (disk &optional player))

(defgeneric num-chapters (disk))
(defgeneric (setf num-chapters) (value disk))

(defgeneric num-frames (disk))
(defgeneric (setf num-frames) (value disk))

(defgeneric tty (player))
(defgeneric (setf tty) (value player))


;; variables

(defvar *current-player* nil)
(defvar *last-arg* "")
(defvar *reply-pending* nil)
(defvar *real-player-p* nil)

