(in-package "PT")

;; should dynamic methods be compiled when established?
(defvar *compile-dynamic-methods* nil)

;; if not, store the compilation code for later use
(defvar *dynamic-method-compilation-queue* nil)

;; garbage collection control
(defvar *gc-allowed* t)

;; Table with event callbacks for widgets
(defvar *event-handler-table* (make-hash-table :size 40 :rehash-size 10))

;; resource database
(defvar *resource-database* nil)

;; system-wide defaults
;; *picasso-defaults-path* is in headers/compat.cl

;; user defaults
(defvar *user-defaults-path* "~/.picasso-defaults")

;; event-descriptor table
(defvar *descriptor-table* (make-array 35))

;; button times
(defvar *button-event-time* 0)
(defvar *button-double-time* 0)

;; caches for event dispatch
(defvar *window-cache* nil)
(defvar *window-cache-res* nil)

;; graphics context variables
(defvar *global-gc-hashtab* (make-hash-table :test #'equal))
(defvar *default-gc-spec*
  '(:arc-mode :pie-slice :background "white" :cap-style :butt :clip-mask :none
              :clip-ordering :unsorted :clip-x 0 :clip-y 0 :dash-offset 0
              :dashes 4 :exposures :off :fill-rule :even-odd :fill-style :solid
              :font nil :foreground "black" :function #+allegro 2 #+lucid 5
              :join-style :miter :line-style :solid :line-width 0
              :plane-mask nil :stipple nil :subwindow-mode :clip-by-children
              :tile nil :ts-x 0 :ts-y 0))
(defvar *shared-gc-cache* (make-hash-table :test #'equal))

;; window states

(defvar :pending :pending "window is exposed, but not visible for other reason")
(defvar :exposed :exposed "window is exposed")
(defvar :concealed :concealed "window is concealed (not exposed)")

;; window ID table

(defvar *objid-window-table* (make-hash-table :test #'equal))

;; X window keywords

(defvar :tile-mode-absolute "tile with respect to window origin")
(defvar :tile-mode-relative "tile with respect to parent origin")
(defvar :clip-mode-clipped "suppress output into areas covered by children")
(defvar :clip-mode-drawthru "output into areas covered by children")

;; global display variables

(defvar *current-display* nil)
(defvar *current-root* nil)
(defvar *current-screen* nil)
(defvar *active-displays* nil)
(defvar *display-table* (make-hash-table :size 10 :rehash-size 5 :test #'eql))
(defvar *class-event-table* 
        (make-hash-table :size 70 :rehash-size 10 :test #'eql))

;; tables to map clx ids to Picasso objects

(defvar *global-display-hashtab*
    (make-hash-table :size 5 :rehash-size 5 :test #'eq))

(defvar *global-window-table-hashtab*
    (make-hash-table :size 5 :rehash-size 5 :test #'eq))

;; table for lazy evaluation

(defvar *lazy-table* (make-hash-table :test #'equal))

;; framework variables

(defvar *current-environment* nil)
(defvar *starting-po-list* nil)
(defvar *current-dialogs* nil)
(defvar *current-panel* nil)
(defvar *current-frames* nil)
(defvar *current-tool* nil)

(defvar *objid* 0)

(defvar *global-dict* (make-hash-table :test #'equal))

(defvar *package-search-list* :uninitialized)

;; propagation tables 

(defvar *prop-table* (make-hash-table :test #'equal))
(defvar *func-table* (make-hash-table :test #'equal))
(defvar *meth-table* (make-hash-table :test #'equal))
(defvar *unbind-table* (make-hash-table :test #'equal))
(defvar *class-meth-table* (make-hash-table :test #'equal))

(defvar *dummy-prop-var* nil)

(defvar *constants-enforced* t)

(defvar *attribute-class* "field")
(defvar *widget-class* "widget")
(defvar *black-and-white-field* "b&w")

(defvar *force-window-output* nil)

(defvar *default-display-name* nil)

(defvar *load-gif-loaded* nil)

(defvar *map-sound-loaded* nil)

(defvar *global-image-hashtab* (make-hash-table :size 300 :test #'equal))

(defvar *2d-vector-free-array* 
        (make-array '(100) :adjustable t :fill-pointer 0))

(defvar *tbg-space-str* (make-string 200 :initial-element #\Space))

(defvar *sound-to-int-array*
  (make-array 256 :element-type 'fixnum
              :initial-contents
'(
-32256 -31228 -30200 -29172 -28143 -27115 -26087 -25059 -24031 -23002
-21974 -20946 -19918 -18889 -17861 -16833 -16062 -15548 -15033 -14519
-14005 -13491 -12977 -12463 -11949 -11435 -10920 -10406 -9892 -9378 -8864
-8350 -7964 -7707 -7450 -7193 -6936 -6679 -6422 -6165 -5908 -5651 -5394
-5137 -4880 -4623 -4365 -4108 -3916 -3787 -3659 -3530 -3402 -3273 -3144
-3016 -2887 -2759 -2630 -2502 -2373 -2245 -2116 -1988 -1891 -1827 -1763
-1698 -1634 -1570 -1506 -1441 -1377 -1313 -1249 -1184 -1120 -1056 -992
-927 -879 -847 -815 -783 -751 -718 -686 -654 -622 -590 -558 -526 -494
-461 -429 -397 -373 -357 -341 -325 -309 -293 -277 -261 -245 -228 -212
-196 -180 -164 -148 -132 -120 -112 -104 -96 -88 -80 -72 -64 -56 -48 -40
-32 -24 -16 -8 0 32256 31228 30200 29172 28143 27115 26087 25059 24031
23002 21974 20946 19918 18889 17861 16833 16062 15548 15033 14519 14005
13491 12977 12463 11949 11435 10920 10406 9892 9378 8864 8350 7964 7707
7450 7193 6936 6679 6422 6165 5908 5651 5394 5137 4880 4623 4365 4108
3916 3787 3659 3530 3402 3273 3144 3016 2887 2759 2630 2502 2373 2245
2116 1988 1891 1827 1763 1698 1634 1570 1506 1441 1377 1313 1249 1184
1120 1056 992 927 879 847 815 783 751 718 686 654 622 590 558 526 494
461 429 397 373 357 341 325 309 293 277 261 245 228 212 196 180 164
148 132 120 112 104 96 88 80 72 64 56 48 40 32 24 16 8 0
)))

(defvar *deferred-clauses* nil)

(defvar *ft-parse-flag* nil)
(defvar *ft-compile-flag* nil)
(defvar *pip-pos* nil)
