(in-package "LIBPQ")

(defvar *libpq-loaded* nil
  "Used for determining if the libpq library object file is loaded")

;; *libpq-dot-o-file* is in headers/compat.cl

(defvar *libpq-argument-check* nil)

(defvar *libpq-available* nil)

;;;
;;; Some constants required by the protocol
;;;
(defconstant *no-result* 0)
(defconstant *var-length-result* -1)
(defconstant *var-length-arg* -5)
(defconstant *integer-result* 4)
(defconstant *integer-arg* -4)
(defconstant *portal-result* -2)

(defvar PBlist nil)
(defconstant PBsize 64)

(defvar TBlist nil)
(defconstant TBsize 128)

(defvar IBlist nil)
(defconstant IBsize 32)

(defvar VBlist nil)
(defconstant VBsize 1024)

(defconstant *default-server-hostname* "postgres"
  "The host where backend is running")

(defconstant *default-port* "4321"
  "The default port for communication between the frontend and the backend")

(defconstant *default-tty*  "/dev/null"
  "The tty for backend debugging message output")

(defconstant *default-option* ""
  "Options, not used at this moment")

(defconstant error-msg-length 80
  "The length of the error message returned by the backend")

(defconstant portal-name-length 16
  "The length of a portal name")

(defconstant command-length 20
  "The length of a query command returned from the POSTGRES backend")

(defconstant remark-length 80
  "The length of a remark returned from the POSTGRES backend")

(defvar ID-VAL "T")
(defvar BYTELEN 8)
(defvar BITMAP (make-array 100 :element-type '(unsigned-byte 8)))

(defvar G-VBLOCK nil)
(defvar G-VBLOCK-PTR 0)

(defvar *portal-table*
  (make-hash-table
   :test #'equal
   :size 64
   :rehash-size 2)
  "A hash table mapping portal names to their buffers")

;;;
;;; The value of the first four variables can be changed by setting
;;; the appropriate environment variables.
;;; *pqhost*: PGHOST
;;; *pqport*: PGPORT
;;; *pqtty*:  PGTTY
;;; *pqoption*: PGOPTION
;;;
;;; Their default values are defined in the file defaults.cl.
;;;

(defvar *pqhost* nil
  "The host on which the POSTGRES backend is running")

(defvar *pqport* nil
  "The communication port with the POSTGRES backend")

(defvar *pqtty* nil
  "The tty on *pqhost* to display backend messages")

(defvar *pqoption* nil
  "Optional arguments passed to the POSTGRES backend")

(defvar *pqportset* nil
  "T if the communication port with the POSTGRES backend is set")

(defvar *pqxactid* 0
  "The POSTGRES transaction id")

(defvar *pqdatabase* nil
  "The POSTGRES database to access")

(defvar *initstr* nil
  "The initialization string passed to the POSTGRES backend")

(defvar *pqtrace* nil
  "Print out the trace message if the value of this variable is T")

(defsetf pqdatabase setf-pqdatabase)

(defmacro pqdebug (msg)
  `(if *pqtrace*
      (format t "~A~%" ,msg)))

