(in-package "PT")

(defconstant *library-pathname* 
  (pathname (picasso-path "lib/bitmaps/")))

(defconstant *video-machines* '(LINUS.CS.BERKELEY.EDU LINUS.BERKELEY.EDU))

(defconstant *video-machine-names* '("localhost" "linus" "linus.cs.berkeley.edu" "linus.berkeley.edu"))

(defconstant *picasso-dict-path* (picasso-path "lib/po"))

(defconstant *anchor-gm-magic-id* '*anchor-gm-magic-id*)

(defconstant *linear-gm-magic-atom* '*linear-gm-magic-atom*)

(defconstant *matrix-gm-magic-id* '*matrix-gm-magic-id*)

(defconstant *packed-gm-magic-id* '*packed-gm-magic-id*)

(defconstant *rubber-gm-magic-id* '*rubber-gm-magic-id*)

(defconstant *stacked-gm-magic-atom* '*stacked-gm-magic-atom*)

(defconstant *resource-types* '(color image tile font image))

(defconstant *paint-types* '(color image tile))

(defconstant *not-visible* 1 "window is exposed, but parent is not")

(defconstant *pended* 2 "window is exposed, but shrunk to zero size")

(defconstant *default-cursor-name* "arrow")

(defconstant *default-font-name* "8x13")
;; *default-font-path* in headers/compat.cl

(defconstant *gif-id* "GIF87a")
;; *load-gif-object-location* in headers/compat.cl

;; *map-sound-file* and *map-sound-foreign-files* in headers/compat.cl
(defconstant *map-sound-system-libraries* #+allegro '("m")
					  #+lucid '("-lm"))

(defconstant *deftool-clauses*
  '((psl :single-sexpr package-search-list)
    (setup-code :single-sexpr )
    (init-code :single-sexpr )
    (exit-code :single-sexpr )
    (static-variables :var-list static-variable static static-locals)
    (dynamic-variables :var-list dynamic-variable dynamic dynamic-locals variables variable)
    (constants :var-list constant constant-variables)
    (region :single-sexpr )
    (x-offset :single-sexpr x)
    (y-offset :single-sexpr y)
    (width :single-sexpr w)
    (height :single-sexpr h)
    (width-increment :single-sexpr)
    (height-increment :single-sexpr)
    (size :single-sexpr area)
    (location :single-sexpr )
    (autoraise :single-sexpr raise)
    (autowarp :single-sexpr deiconify-warp warp)
    (icon :object-eval-sexpr )
    (icon-name :single-sexpr )
    (title :single-sexpr )
    (frames :multiple-sexpr frame)
    (dialogs :multiple-sexpr dialog)
    (panels :multiple-sexpr panel)
    (start-frame-args :single-sexpr sfa)
    (start-frame :single-sexpr start)))

(defconstant *defframe-clauses*
  '((setup-code :single-sexpr )
    (init-code :single-sexpr )
    (exit-code :single-sexpr )
    (static-variables :var-list static-variable static static-locals variable variables)
    (dynamic-variables :var-list dynamic-variable dynamic dynamic-locals)
    (constants :var-list constant constant-variables)
    (form-background :single-sexpr background)
    (form-gray :single=sexpr gray)
    (forms :multiple-sexpr form)
    (form-args :multiple-sexpr fa)
    (dialogs :multiple-sexpr dialog)
    (panels :multiple-sexpr panel)
    (form-children :multiple-sexpr children child)
    (form-visit-order :multiple-sexpr visit-order)
    (form-selectable :multiple-sexpr selectable)
    (menu-bar :single-sexpr menu)
    (gm :single-sexpr geometry-manager)))

(defconstant *defpanel-clauses*
  '((setup-code :single-sexpr )
    (init-code :single-sexpr )
    (exit-code :single-sexpr )
    (static-variables :var-list static-variable static static-locals)
    (dynamic-variables :var-list dynamic-variable dynamic dynamic-locals variable variables)
    (attach-when-possible :single-sexpr attach)
    (constants :var-list constant constant-variables)
    (forms :multiple-sexpr form)
    (form-args :multiple-sexpr fa)
    (dialogs :multiple-sexpr dialog)
    (panels :multiple-sexpr panel)
    (form-children :multiple-sexpr children child)
    (form-visit-order :multiple-sexpr visit-order)
    (form-selectable :multiple-sexpr selectable)
    (form-background :single-sexpr background)
    (form-gray :single=sexpr gray)
    (menu-bar :single-sexpr menu)
    (gm :single-sexpr geometry-manager)
    (buttons :multiple-sexpr button)
    (iconify-func :single-sexpr)
    (deiconify-func :single-sexpr)
    (title :single-sexpr )
    (icon :object-eval-sexpr )
    (icon-name :single-sexpr )
    (autoraise :single-sexpr raise)
    (autowarp :single-sexpr warp deiconify-warp)
    (region :single-sexpr )
    (x-offset :single-sexpr x)
    (y-offset :single-sexpr y)
    (width :single-sexpr w)
    (height :single-sexpr h)
    (width-increment :single-sexpr)
    (height-increment :single-sexpr)
    (size :single-sexpr area)
    (location :single-sexpr )))

(defconstant *defdialog-clauses*
  '((setup-code :single-sexpr )
    (init-code :single-sexpr )
    (exit-code :single-sexpr )
    (static-variables :var-list static-variable static static-locals)
    (dynamic-variables :var-list dynamic-variable dynamic dynamic-locals variable variables)
    (attach-when-possible :single-sexpr attach)
    (constants :var-list constant constant-variables)
    (forms :multiple-sexpr form)
    (form-args :multiple-sexpr fa)
    (form-background :single-sexpr background)
    (form-gray :single=sexpr gray)
    (dialogs :multiple-sexpr dialog)
    (form-children :multiple-sexpr children child)
    (form-visit-order :multiple-sexpr visit-order)
    (form-selectable :multiple-sexpr selectable)
    (gm :single-sexpr geometry-manager)
    (buttons :multiple-sexpr button)
    (autoraise :single-sexpr raise)
    (title :single-sexpr )
    (icon :object-eval-sexpr )
    (icon-name :single-sexpr )
    (region :single-sexpr )
    (x-offset :single-sexpr x)
    (y-offset :single-sexpr y)
    (width :single-sexpr w)
    (height :single-sexpr h)
    (width-increment :single-sexpr)
    (height-increment :single-sexpr)
    (size :single-sexpr )
    (location :single-sexpr )))

(defconstant *defform-clauses*
  '((setup-code :single-sexpr )
    (init-code :single-sexpr )
    (exit-code :single-sexpr )
    (static-variables :var-list static-variable static static-locals)
    (dynamic-variables :var-list dynamic dynamic-locals variable variables)
    (constants :var-list constant constant-variables)
    (dialogs :multiple-sexpr dialog)
    (background :single-sexpr form-background)
    (panels :multiple-sexpr panel)
    (children :multiple-sexpr child)
    (visit-order :multiple-sexpr)
    (selectable :multiple-sexpr)
    (gm :single-sexpr geometry-manager)))

(defconstant *picasso-menu-structure*
  '(picasso-menu ("Picasso" :tearable nil "Picasso Menu"
                            ("Quit" (let ((edb #!exit-dialog))
                                         (if edb (call edb)
                                                 (ret-tool)))))))

(defconstant *menu-items* 10)
(defconstant *menu-shadow-thickness* 7)

(defconstant *mf-value-init* 'mf-value-init)

