(in-package "PT")

(defclass pmc () nil)
(defclass window (pmc) nil)
(defclass x-window (window) nil)
(defclass opaque-window (x-window) nil)
(defclass widget (opaque-window) nil)
(defclass gadget (window) nil)
(defclass synth-gadget (gadget) nil)
(defclass null-gadget (gadget) nil)
(defclass collection-gadget (gadget) nil)
(defclass collection-widget (widget collection-gadget) nil)
(defclass variable-holder (pmc) nil)
(defclass root-window (variable-holder opaque-window collection-gadget) nil)

(defclass button (widget) nil)
(defclass click-button (button) nil)
(defclass gray-button (button) nil)
(defclass gray-pop-button (button) nil)
(defclass pop-button (button) nil)

(defclass check-button (widget) nil)
(defclass button-group (widget) nil)
(defclass check-group (button-group) nil)
(defclass radio-group (button-group) nil)

(defclass arb-widget (widget) nil)
(defclass null-widget (widget) nil)
(defclass enclosure-widget (collection-widget) nil)
(defclass indicator (widget) nil)
(defclass indicator-widget (indicator) nil)
(defclass meter-slider (widget) nil)
(defclass meter-widget (collection-widget) nil)
(defclass qual-widget (collection-widget) nil)
(defclass scroll-bar (widget) nil)
(defclass scroll-widget (collection-widget) nil)

(defclass picasso-object (variable-holder collection-widget) nil)
(defclass top-level-po (picasso-object) nil)
(defclass callable-po (picasso-object) nil)
(defclass form (picasso-object) nil)
(defclass frame (callable-po) nil)
(defclass dialog (top-level-po callable-po) nil)
(defclass panel (top-level-po callable-po) nil)
(defclass tool (top-level-po) nil)

(defclass color (pmc) nil)
(defclass colormap (pmc) nil)
(defclass cursor (pmc) nil)
(defclass dtext (pmc) nil)
(defclass display (pmc) nil)
(defclass screen (pmc) nil)
(defclass font (pmc) nil)
(defclass image (pmc) nil)
(defclass tile (pmc) nil)
(defclass icon (tile) nil)

(defclass variable (pmc) nil)
(defclass constant (variable) nil)
(defclass alerter (variable) nil)

(defclass display-list (pmc) nil)
(defclass annot-dl (display-list) nil)
(defclass segment-dl (display-list) nil)

(defclass shape (pmc) nil)
(defclass 2d-shape (shape) nil)
(defclass annotation (2d-shape) nil)
(defclass segment (2d-shape) nil)
(defclass polygon (segment) nil)
(defclass box (polygon) nil)
(defclass line-segment (polygon) nil)

(defclass 2d-mapper-mixin (pmc) nil)
(defclass simple-graphic-gadget (2d-mapper-mixin gadget) nil)
(defclass simple-graphic-browser (widget simple-graphic-gadget) nil)
(defclass graphic-gadget (2d-mapper-mixin gadget) nil)
(defclass graphic-browser (widget graphic-gadget) nil)
(defclass rover-widget (widget) nil)
(defclass pw-pane (collection-widget) nil)
(defclass plot-widget (collection-widget) nil)

(defclass paint-gadget (gadget) nil)


(defclass image-widget (widget synth-gadget) nil)

(defclass menu-entry (pmc) nil)
(defclass menu-item (pmc) nil)
(defclass menu-button (gray-button) nil)
(defclass menu-bar (collection-gadget) nil)
(defclass menu-pane (collection-widget) nil)

(defclass bw-sync (pmc) nil)
(defclass los-gadget (gadget) nil)
(defclass tf-button (click-button) nil)
(defclass browse-widget (collection-widget) nil)
(defclass matrix-field (collection-widget) nil)
(defclass table-field (collection-widget) nil)
(defclass list-box (table-field) nil)

(defclass buffer (pmc) nil)
(defclass text-buffer-gadget (gadget) nil)
(defclass text-widget (widget text-buffer-gadget) nil)
(defclass entry-widget (text-widget) nil)
(defclass num-entry (entry-widget) nil)
(defclass scrollable-num-entry (collection-widget) nil)
(defclass scrolling-text-widget (collection-widget) nil)
(defclass text-output-widget (widget text-gadget) nil)

(defclass sound-widget (widget) nil)
(defclass video-widget (widget) nil)

(defclass portal (pmc) nil)
