;;; -*-Mode: LISP; Package: PICASSO; Base: 10; Syntax: Common-lisp -*-
;;;
;;; Postgres Interactive Common Application System for Shared Objects
;;;
;;; Copyright (c) 1991 Regents of the University of California
;;;
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;;
;;; $Author: smoot $
;;; $Source: /pic2/picasso/lib/po/picasso/RCS/file-selection.cl,v $
;;; $Revision: 1.2 $
;;; $Date: 1991/09/11 00:57:20 $
;;;

;;; These are the common subroutines for open-file, save-file, and select-files
;;; note they must be executed in an env. where several picasso-vars are defined:
;;; sort, dir, old-dir, ...

(in-package "PT")

(defun open-dialog-new-dir (dirname)
  (setf #!dir "loading...")
  (flush-display)  ;; otherwise message doesn't go out
  (setf (data  #!doc-list)
	(cons (list "../")
	      (let ((result 
		     (mapcar #'(lambda (f) 
				 (list (if (get-non-dir f)
					   (file-namestring f)
					 (concatenate 'string 
						      (file-namestring f) 
						      "/"))))
			     (user::directory dirname))))
		(if #!sort
		    (sort result #'string< :key #'(lambda (x) (car x)))
		  result))))
  (setf #!dir dirname)
  )



(defun get-alt-path ()
  (let ((pn (value #!alt-path)))
    (if (string= pn "")
	(xlib:bell (res (current-display)))
      (progn
	(if (not (eq #\/ (char pn 0)))	; non absolute pathname
	    (setq pn (namestring (merge-pathnames pn #!dir))))
	(if (eq #\/ (char pn (max 0 (1- (length pn)))))
	    (progn			; given a pathname (ends in /)
	      (if (probe-file pn)
		  (progn
		    (open-dialog-new-dir (namestring pn))
		    (setf (value #!alt-path) '()))
		(xlib:bell (res (current-display)))))
	  (progn			; given a filename	
	    (if (get-non-dir pn)
		(progn
		  (setf (value #!alt-path) '())
		  (setf #!old-dir (directory-namestring pn)) 
		  (ret (parent #!po) pn))
	      (if (probe-file pn)
		  (progn
		    (setf (value #!alt-path) '())
		    (open-dialog-new-dir (concatenate 'string pn "/")))
		(if (and (not #!load-non-existing) 
			 (probe-file (directory-namestring pn)))
		    (xlib:bell (res (current-display)))
		  (progn
		    (if #!confirm-non-existing
			(if (call (find-po-named '("picasso" "confirmer" . "dialog"))
				  :msg (concatenate 'string #!label
						    " even though file doesn't exist?"))
			    (progn
			      (setf (value #!alt-path) '())
			      (setf #!old-dir (directory-namestring pn))
			      (ret (parent #!po) pn)))
		      (progn
			(setf (value #!alt-path) '())
			(setf #!old-dir (directory-namestring pn))
			(ret (parent #!po) pn))))
		  )))))))))

 

(defun get-non-dir (name)
#+allegro
  (multiple-value-bind (worked-p val) 
		       (excl:errorset
			(excl::probe-file-non-directory name))
		       (if worked-p val t))
#+lucid
  (progn (warn "Cannot probe in lucid") t)  ;;; I dont know how....
)
