;;;
;;;  Compiles and loads the specified files in the SRC directory and
;;;  deposits the fasl files in the appropriate subdirectory of the OBJ 
;;;  directory.
;;;  The name of the subdirectory is the string returned by machtype.
;;;

;;  SRC directory
(defconstant *dialog-dir-src-dir* "~picasso/lib/po/picasso")

;;  OBJ directory
(defvar *dialog-dir-obj-dir* "~picasso/lib/po/picasso/OBJ")

;;  files to load/compile
(defconstant *dialog-dir-load-files* 
  '("dialog-dir"))

(defvar *dialog-dir-fasl-file* nil)
(defvar *dialog-dir-fasl-dir* nil)
(setq *dialog-dir-fasl-dir* 
  (concatenate 'string *dialog-dir-obj-dir* "/"
				  #+DEC3100 "3100"
				  #+sun4 "sun4"
				  #+sun3 "sun3"
				  #+sequent "sequent"
				  #+(and mips (not DEC3100)) "mips"))

;;  compile and load files
(dolist (file *dialog-dir-load-files*)
  (setq *dialog-dir-file-fasl* 
	(concatenate 'string *dialog-dir-fasl-dir* "/" file ".fasl"))
  (excl:compile-file-if-needed 
   (make-pathname :directory *dialog-dir-src-dir* :name file)
   :output-file *dialog-dir-file-fasl*)
  (load  *dialog-dir-file-fasl*))
