;;; -*-Mode: LISP; Package: PICASSO; Base: 10; Syntax: Common-lisp -*-
;;;
;;; Postgres Interactive Common Application System for Shared Objects
;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;
;;; Permission to use, copy, modify, and distribute this software and its
;;; documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notice appear in all copies and
;;; that both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of the University of
;;; California not be used in advertising or publicity pertaining to
;;; distribution of the software without specific, written prior
;;; permission.  The University of California makes no representations
;;; about the suitability of this software for any purpose.  It is
;;; provided "as is" without express or implied warranty.
;;;
;;;
;;;       $Source: /n/hermes/pic2/picasso/lib/po/mosaic/RCS/support.cl,v $
;;;       $Author: johnb $
;;;       $Header: /n/hermes/pic2/picasso/lib/po/mosaic/RCS/support.cl,v 1.7 1991/11/19 02:28:01 johnb Exp smoot $
;;;       $Locker: smoot $
;;;

; constants
(defconstant TileSize 20 "Number of pixels on a side of the Tile")
(defconstant PieceSize (* 2 TileSize)  "Number of pixels on a side of a piece")
(defconstant zero-tile (make-image :file "zerobits2.bitmap") "`blank' bitmap")
(defvar one-tile)
(defvar two-tile)
(defvar three-tile)
(defvar force-screen)

; macros
(defmacro num->string (n) `(format '() "~d" ,n))
(defmacro mosaic-color (n)
  `(make-color :attach-p t
	       :name (get-default "mosaic"
				  '(,n "color"))))

; functions
(defun Setup-Tiles ()
  (if (or 
       (and (boundp 'force-screen) (eq force-screen 'black-and-white))
       (let ((bw-def (get-default "mosaic" '("force-black-and-white"))))
	 (if (not (null bw-def))
	     (not (null (member bw-def  '("true" "t" "on" "yes") :test #'string-equal)))
	   nil))
       (black-and-white-display-p)
       )
      (progn
	(setf one-tile (make-image :file (get-default "mosaic"
						      '("one" "bitmap"))))
	(setf two-tile (make-image :file (get-default "mosaic"
						      '("two" "bitmap"))))
	(setf three-tile (make-image :file (get-default "mosaic"
							'("three" "bitmap")))))
    (progn
      (setf one-tile (mosaic-color "one"))
      (setf two-tile (mosaic-color "two"))
      (setf three-tile (mosaic-color "three")))))

(defun drop-on-table  (event)
  (when (not (null event))
	(let ((row (caar event))
	      (col (cadar event)))
	  (if (and (< nextpiece NPieces)
		   (DropPiece row col (nextpiece)))
	      (progn			; Piece fits there
		(setf nextpiece (1+ nextpiece))
		(Update-Board row col)
		(Update-Totals)
		(Update-Next-Piece)
		t
		)
	    (progn ;; piece doesn't fit  -- return nil
	      (if (= nextpiece NPieces) 
		  (Check-and-Display-High-Scores)
		(xlib:bell (res (current-display))))
	      '())))))


(defmacro num->tile (n)
  `(cond ((= ,n 1) one-tile)
	 ((= ,n 2) two-tile)
	 ((= ,n 3) three-tile)
	 (t zero-tile)))

(defun Clear-Board ()
  (do ((i 0 (1+ i)))
      ((= i BoardSize))
      (do ((j 0 (1+ j)))
	  ((= j BoardSize))
	  (setf (mref (matrix-field #!board) j i) zero-tile))))
  
(defun Update-Board (row col)
  (setf (mref (matrix-field #!board) row col) 
	(mref (matrix-field #!piece-box) 0 0))
  (setf (mref (matrix-field #!board) row (1+ col)) 
	(mref (matrix-field #!piece-box) 0 1))
  (setf (mref (matrix-field #!board) (1+ row) col) 
	(mref (matrix-field #!piece-box) 1 0))
  (setf (mref (matrix-field #!board) (1+ row) (1+ col)) 
	(mref (matrix-field #!piece-box) 1 1)))
  
(defun Update-Next-Piece ()
  (if (= nextpiece NPieces)  ; just put up last piece
      (progn
	(setf (mref (matrix-field #!piece-box) 0 0) 
	      zero-tile)
	(setf (mref (matrix-field #!piece-box) 0 1) 
	      zero-tile)
	(setf (mref (matrix-field #!piece-box) 1 0) 
	      zero-tile)
	(setf (mref (matrix-field #!piece-box) 1 1) 
	      zero-tile))
    (progn
      (setf (mref (matrix-field #!piece-box) 0 0)
	    (num->tile (pc-ul (nextpiece))))
      (setf (mref (matrix-field #!piece-box) 0 1) 
	    (num->tile (pc-ur (nextpiece))))
      (setf (mref (matrix-field #!piece-box) 1 0) 
	    (num->tile (pc-ll (nextpiece))))
      (setf (mref (matrix-field #!piece-box) 1 1) 
	    (num->tile (pc-lr (nextpiece)))))))
 

(defun Update-Totals ()
  (setf (value #!piece-total) (num->string (+ (aref pscore 0) 
					      (aref pscore 1) 
					      (aref pscore 2))))
  (setf (value #!piece-three) (num->string (aref pscore 2)))
  (setf (value #!piece-two) (num->string (aref pscore 1)))
  (setf (value #!piece-one) (num->string (aref pscore 0)))
  (setf (value #!total-total) (num->string (+ (aref tscore 0) 
					      (aref tscore 1) 
					      (aref tscore 2))))
  (setf (value #!total-three) (num->string (aref tscore 2)))
  (setf (value #!total-two) (num->string (aref tscore 1)))
  (setf (value #!total-one) (num->string (aref tscore 0)))
  (setf (value #!play-three) (num->string (aref remain 3)))
  (setf (value #!play-two) (num->string (aref remain 2)))
  (setf (value #!play-one) (num->string (aref remain 1))))


(defun Check-and-Display-High-Scores ()
  (if (and (Check-High-Scores)
	   (not (me-dimmed #!hs-entry)))
      (progn
	(setf (me-dimmed #!hs-entry) t)
	(call #!hs-panel))))
