(in-package "PT")
#+cling (use-package "CLING")

;;;
;;; Define the class hierarchy for the facility database schema.
;;;

(defclass wall (fac-object)
  ((id :initarg :id :initform 0 :type integer :accessor id)
   (v1 :initarg :v1 :initform 0 :type integer :accessor v1)
   (v2 :initarg :v2 :initform 0 :type integer :accessor v2)
   (tuple :initarg :tuple :initform nil :type list :accessor tuple)))

(defun wall-p (x) (typep x 'wall))

;;; =============================================================
;;;
;;; Convert a wall tuple to a CLOS wall object.
;;;
(defun make-wall-from-tuple (tuple)
  ;; Tuples are of form (id v1 v2)
  (let* ((id (first tuple))
	 (v1 (second tuple))
	 (v2 (third tuple))
	 (line (new-sgg-line v1 v2))
	 rv)
	(setq rv (make-instance 'wall :id id :v1 v1 :v2 v2 :tuple tuple))
	(new-sgg-object :id rv
			:line-ids (list line)
			:annot-ids nil
			:symbol-ids nil
			:selectable nil
			:visible t
			:color "white"
			:line-width 0)
	rv))

;;;
;;; Read all the wall from the database -- faked, for now.
;;; Return a list of the objects read.
;;;
#-cling
(defun read-db-wall (fac-id)
  "Read the wall from the database for this facility and build the wall objects."
  (let* ((in-file (open (picasso-path "lib/db/wall") :direction :input))
	 (rv (mapcar #'make-wall-from-tuple (do-read in-file nil nil))))
	(close in-file)
	;; Set the fac-id of each. We may also wish to set the color, etc.
	(dolist (obj rv) (setf (fac-id obj) fac-id))
	rv))

#+cling
(defun read-db-wall (fac-id)
  "Read the wall from the database for this facility and build the wall objects."
  (let ((rv (db-mapl-retrieve
	     #'make-wall-from-tuple
	     '((:integer wall.id) 
	       (:integer wall.vrtx1)
	       (:integer wall.vrtx2)))))
       ;; Set the fac-id.
       (dolist (obj rv) (setf (fac-id obj) fac-id))
       rv))

(defun save-db-wall (wlist)
  (let ((tuple-list (mapcar #'tuple wlist))
	(out-file (open (picasso-path "lib/db/wall") :direction :output)))
       (format out-file "(")
       (dolist (tup tuple-list)
	       (format out-file "~s~%" tup))
       (format out-file ")")
       (close out-file)))
