(in-package "PT")
#+cling (use-package "CLING")

;;;
;;; Define the class hierarchy for the facility database schema.
;;;

(defclass label ()
  ((tuple :initarg :tuple :initform nil :type list :accessor tuple)))

(defun label-p (x) (typep x 'label))

;;; =============================================================
;;;
;;; Convert a label tuple to a CLOS label object.
;;;
(defun make-label-from-tuple (tuple)
  ;; Tuples are of form (name x y)
  (let* ((name (trim-str (first tuple)))
	 (x (second tuple))
	 (y (third tuple))
	 (av (new-sgg-vertex x y))
	 rv)
	(setq rv (make-instance 'label :tuple tuple))
	(new-sgg-object :id rv
			:line-ids nil
			:annot-ids (list (new-sgg-annotation name av 5 5))
			:symbol-ids nil
			:selectable nil
			:visible t
			:color "white"
			:line-width 0)
	rv))

;;;
;;; Read all the label from the database -- faked, for now.
;;; Return a list of the objects read.
;;;
#-cling
(defun read-db-label (fac-id)
  (declare (ignore fac-id))
  (let* ((in-file (open (picasso-path "lib/db/label") :direction :input))
	 (rv (mapcar #'make-label-from-tuple (do-read in-file nil nil))))
	(close in-file)
	rv))

#+cling
(defun read-db-label (fac-id)
  (declare (ignore fac-id))
  (db-mapl-retrieve #'make-label-from-tuple 
		    '((:string label.name)
		      (:float label.x)
		      (:float label.y))))

(defun save-db-label (llist)
  (let ((tuple-list (mapcar #'tuple llist))
	(out-file (open (picasso-path "lib/db/label") :direction :output)))
       (format out-file "(")
       (dolist (tup tuple-list)
	       (format out-file "~s~%" tup))
       (format out-file ")")
       (close out-file)))

