(in-package "PT")

(defmacro xor (a b)
  "Return a xor b as a logical operation."
  `(if ,a (not ,b) ,b))

(defmacro do-read (strm eerr eval)
  `(read ,strm ,eerr ,eval #+allegro t #+lucid nil))

(defmacro trim-str (str)
  `(string-trim '(#\Space #\Tab #\Newline) ,str))

(defconstant *lot-title*
"Run#           Start Time     Process Flow         Mask Set    Status  Yield ")
(defconstant *eq-space* 0)
(defconstant *eq-util* 1)
(defconstant *eq-lots* 2)
(defconstant *eq-junct* 3)
(defconstant *junct-equip* 0)
(defconstant *junct-util* 1)
(defconstant *junct-space* 2)
(defconstant *lot-equip* 0)
(defconstant *space-equip* 0)
(defconstant *space-junct* 1)
(defconstant *util-equip* 0)
(defconstant *util-junct* 1)


(push :cimtool-support *features*)

(defclass label () nil)
(defclass facility () nil)
(defclass fac-object () nil)
(defclass equipment (fac-object) nil)
(defclass personnel (fac-object) nil)
(defclass junct-kind (fac-object) nil)
(defclass junction (fac-object) nil)
(defclass eq-junction (junction) nil)
(defclass lot (fac-object) nil)
(defclass space (fac-object) nil)
(defclass utility (fac-object) nil)
(defclass connection () nil)
(defclass vertex () nil)
(defclass wall (fac-object) nil)

(defgeneric age (self))
(defgeneric (setf age) (value self))

(defgeneric bitmaps (self))
(defgeneric (setf bitmaps) (value self))

(defgeneric class (self))
(defgeneric (setf class) (value self))

(defgeneric clean-level (self))
(defgeneric (setf clean-level) (value self))

(defgeneric descrip (self))
(defgeneric (setf descrip) (value self))

(defgeneric dst-id (self))
(defgeneric (setf dst-id) (value self))

(defgeneric equip-id (self))
(defgeneric (setf equip-id) (value self))

(defgeneric fac-id (self))
(defgeneric (setf fac-id) (value self))

(defgeneric id (self))
(defgeneric (setf id) (value self))

(defgeneric kind (self))
(defgeneric (setf kind) (value self))

(defgeneric kind-id (self))
(defgeneric (setf kind-id) (value self))

(defgeneric lot-str (self))

(defgeneric make (self))
(defgeneric (setf make) (value self))

(defgeneric manager (self))
(defgeneric (setf manager) (value self))

(defgeneric mask-set (self))
(defgeneric (setf mask-set) (value self))

(defgeneric name (self))
(defgeneric (setf name) (value self))

(defgeneric phone (self))
(defgeneric (setf phone) (value self))

(defgeneric picture-keys (self))
(defgeneric (setf picture-keys) (value self))

(defgeneric process-flow (self))
(defgeneric (setf process-flow) (value self))

(defgeneric rating (self))
(defgeneric (setf rating) (value self))

(defgeneric run-num (self))
(defgeneric (setf run-num) (value self))

(defgeneric space-id (self))
(defgeneric (setf space-id) (value self))

(defgeneric src-id (self))
(defgeneric (setf src-id) (value self))

(defgeneric start-time (self))
(defgeneric (setf start-time) (value self))

(defgeneric status (self))
(defgeneric (setf status) (value self))

(defgeneric tuple (self))
(defgeneric (setf tuple) (value self))

(defgeneric usage (self))
(defgeneric (setf usage) (value self))

(defgeneric util-id (self))
(defgeneric (setf util-id) (value self))

(defgeneric v1 (self))
(defgeneric (setf v1) (value self))

(defgeneric v2 (self))
(defgeneric (setf v2) (value self))

(defgeneric vertex-id (self))
(defgeneric (setf vertex-id) (value self))

(defgeneric x (self))
(defgeneric (setf x) (value self))

(defgeneric y (self))
(defgeneric (setf y) (value self))

(defgeneric yield (self))
(defgeneric (setf yield) (value self))

(defvar *sgg-vertices* nil)
(defvar *sgg-lines* nil)
(defvar *sgg-annots* nil)
(defvar *sgg-symbols* nil)
(defvar *sgg-symbol-types* nil)
(defvar *sgg-objects* nil)
(defvar *sprinkler-bitmaps* nil)
(defvar *shut-off-bitmaps* nil)
(defvar *end-cap-bitmaps* nil)
(defvar *junction-bitmaps* nil)
(defvar *bulk-head-bitmaps* nil)
(defvar *imaginary-bitmaps* nil)
