;;;
;;; Copyright (c) 1990 Regents of the University of California
;;;
;;; This file contains code to support the building of object abstractions
;;; for FMTOOL.
;;;
;;; $Author$
;;; $Source$
;;; $Revision$
;;; $Date$
;;;

(in-package "PT")

(defun add-sgg-vertex (vertex-spec)
  ;; vertex-list is a list of (id x y) triples
  (push vertex-spec *sgg-vertices*))

(defun new-sgg-vertex (x1 y1)
  (let ((id (gensym)))
       (push (list id x1 y1) *sgg-vertices*)
       id))

(defun new-sgg-line (v1 v2)
  (let ((id (gensym)))
       (push (list id v1 v2) *sgg-lines*)
       id))

(defun new-sgg-annotation (text vertex width height &key
				(horiz-just :center)
				(vert-just :center))
  (let ((id (gensym)))
       (push `(:id ,id :text ,text :vertex-id ,vertex :width ,width :height
		   ,height :horiz-just ,horiz-just :vert-just ,vert-just)
	     *sgg-annots*)
       id))

(defun new-sgg-symbol (type vert &key (horiz-just :center) (vert-just :center))
  (let ((id (gensym)))
       (push `(:id ,id :symbol-type-id ,type :vertex-id ,vert
		   :horiz-just ,horiz-just :vert-just ,vert-just)
	     *sgg-symbols*)
       id))

(defun new-sgg-symbol-type (&rest args)
  (push args *sgg-symbol-types*))

(defun new-sgg-object (&rest args)
  (push args *sgg-objects*))

(defun sgg-arg-list ()
  (list :vertices *sgg-vertices*
	:lines *sgg-lines*
	:annotations *sgg-annots*
	:symbols *sgg-symbols*
	:symbol-types *sgg-symbol-types*
	:objects *sgg-objects*))

(defun clear-sgg-arg-list ()
  (setq *sgg-vertices* nil
	*sgg-lines* nil
	*sgg-annots* nil
	*sgg-symbols* nil
	*sgg-symbol-types* nil
	*sgg-objects* nil))
