;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: calc; Base: 10-*-
;;;
;;; Copyright 1990 GMD (German National Research Center for Computer Science)
;;;
;;; Permission to use, copy, modify, distribute, and sell this software and its
;;; documentation for any purpose is hereby granted without fee, provided that
;;; the above copyright notice appear in all copies and that both that
;;; copyright notice and this permission notice appear in supporting
;;; documentation, and that the name of GMD not be used in advertising or
;;; publicity pertaining to distribution of the software without specific,
;;; written prior permission.  GMD makes no representations about the
;;; suitability of this software for any purpose.  It is provided "as is"
;;; without express or implied warranty.
;;;
;;; GMD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL GMD
;;; BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
;;; WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
;;; OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
;;; CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;; Authors: Project GINA (spenke@gmd.de)
;;;          P.O. Box 1316
;;;          D-5205 Sankt Augustin 1
;;;

(in-package :GINA)
(defginapackage :calc)
(in-package :calc)
(setq *sccs-id* "@(#)calculator.lisp	1.6  11/9/92")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;; class calculator
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass calculator (application)
  (;; overrides
   (name          :initform "Calculator"   :allocation :class)
   (document-type :initform 'calc-document :allocation :class)
   (signature     :initform "calc"         :allocation :class)
   (file-type     :initform "calc"         :allocation :class)))

(defun make-calculator ()
  "start the desk-calculator"
  (make-application :class 'calculator))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;; class calc-document
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defclass calc-document (document)
  (;; instance-variables
   (input-value   :accessor input-value   :initform 0)
   (input-string  :accessor input-string  :initform "")
   (decimal-point :accessor decimal-point :initform nil)
   (memory        :accessor memory        :initform 0)
   (operator      :accessor operator      :initform nil)))

(defmethod clear ((doc calc-document))
  "reset everything"
  (setf (input-string doc) "")
  (setf (input-value doc) 0)
  (setf (decimal-point doc) nil)
  (setf (label-string (display (main-shell doc))) "0")
  (setf (memory doc) 0)
  (setf (operator doc) nil))

(defmethod create-windows ((doc calc-document))
  "create the windows belonging to this document"
  (with-slots (main-shell main-view) doc
    ;; create instance of class generated by Interface Builder
    (setq main-shell (make-calculator-shell doc))

    ;; bypass GINAs automatic naming conventions
    (setf (title main-shell) "Calc")
    (set-motif-resources main-shell :icon-name "Calc")))

(defmethod type-digit ((doc calc-document) digit
		       &aux (display (display (main-shell doc))))
  "a digit has been typed"
  (setf (input-string doc)
	(concatenate 'string (input-string doc) (format nil "~d" digit)))
  (when (not (operator doc)) (setf (memory doc) 0))
  (setf (label-string display) (input-string doc)))

(defmethod type-point ((doc calc-document)
		       &aux (display (display (main-shell doc))))
  "a point has been typed"
  (when (not (decimal-point doc))
    (setf (decimal-point doc) t)
    (setf (input-string doc)
	(concatenate 'string (input-string doc) "."))
    (setf (label-string display) (input-string doc))))

(defmethod type-rubout ((doc calc-document)
			  &aux string-length
			       (display (display (main-shell doc))))
  "backspace for input"
  (setq string-length (length (input-string doc)))
  (when (> string-length 0)
    (when (equal (position #\. (input-string doc)) (1- string-length))
      (setf (decimal-point doc) nil))
    (setf (input-string doc) (subseq (input-string doc) 0 (1- string-length)))
    (setf (label-string display) (input-string doc))))

(defmethod type-operator ((doc calc-document) operator
			  &aux (display (display (main-shell doc))))
  "an operator has been typed"
  (setf (input-value doc)
	(if (equal (input-string doc) "")
	    (memory doc)
	    (read-from-string (input-string doc))))
  (setf (input-string doc) "")
  (setf (decimal-point doc) nil)
  (if (operator doc)
    (setf (memory doc)
	  (gina::ignore-errors
	    (funcall (operator doc) (memory doc) (input-value doc))))
    (setf (memory doc) (input-value doc)))
  (setf (operator doc) operator)
  (if (not (memory doc)) 
    (progn (setf (memory doc) 0)
	   (setf (label-string display) "Error"))
    (setf (label-string display) (format nil "~f" (memory doc)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;; main program
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(register-application "calc" 'calculator "calc")
'(make-calculator)
