;;; -*- Mode: Lisp; Syntax: ANSI-Common-Lisp; Package: CLIM-USER; Base: 10; Lowercase: Yes -*-

(in-package :clim-user)

;; Gets a rectangular region via the mouse, and copies it to the new place
(defun copy-window-region (&optional (function boole-1) (stream *standard-output*))
  ;; COPY-AREA works on mediums, so get the medium
  (let ((medium (clim:sheet-medium stream)))
    ;; Get the rectangular region
    (multiple-value-bind (left top right bottom)
        (clim:pointer-input-rectangle* :stream stream)
      ;; Fill a pixmap with the bits from that region
      (let ((pixmap (clim:copy-to-pixmap 
                      medium left top (- right left) (- bottom top))))
	;; Get position for the output
        (multiple-value-bind (x y)
            (block get-position
              (clim:tracking-pointer (stream)
                (:pointer-button-press (x y)
                 (return-from get-position (values x y)))))
	  ;; Copy the bits to that position
          (clim:copy-from-pixmap pixmap 0 0 (- right left) (- bottom top)
                                 medium x y function))
	;; Done with the pixmap, so deallocate it
        (clim:deallocate-pixmap pixmap)))))

(defun do-pixmap-output (&optional (function boole-1) (stream *standard-output*))
  (let ((medium (clim:sheet-medium stream)))
    ;; Generate a pixmap with some stuff in it
    (let ((pixmap (clim:with-output-to-pixmap (mv medium)
                    (clim:formatting-table (mv)
                      (dotimes (i 5)
                        (clim:formatting-row (mv)
                          (clim:formatting-cell (mv) (princ i mv))
                          (clim:formatting-cell (mv) (princ (* i 2) mv)))))
                    (clim:draw-circle* mv 50 50 20 :filled t)
                    (clim:draw-rectangle* mv 0 0 90 90 :filled nil))))
      ;; Get position for the output
      (multiple-value-bind (x y)
          (block get-position
            (clim:tracking-pointer (stream)
              (:pointer-button-press (x y)
               (return-from get-position (values x y)))))
	;; Copy the bits to that position
        (clim:copy-from-pixmap 
          pixmap 0 0 (clim:pixmap-width pixmap) (clim:pixmap-height pixmap)
          medium x y
	  function))
      ;; Deallocate the pixmap
      (clim:deallocate-pixmap pixmap))))
