;;; -*- Mode: LISP; Syntax: Common-Lisp; Base: 10; Package: CLIM-USER -*-
;;; MI2:>keunen>clim>examples>clim-tests-framework.lisp.22,
;;;   Edited by Keunen running on NRBMI1 on 17-Feb-93 15:29:39
;;;   Comments: clarified package stuff
;;; MI2:>keunen>clim>examples>clim-tests-framework.lisp.2,
;;;   Edited by Keunen running on NRBMI1 on 21-Jan-93 16:54:57
;;;   Comments: This file provides the basics to test clim stuff.

#|

Code tested on:
 - a MacIvory model 3, Genera 8.1.1, CLIM 1.1
 - a MacIIfx, MCL 2.0p1, CLIM 1.1
 - Allegro 4.1 with Clim 1 (by Koenraad de Smedt <desmedt@ruls40.leidenuniv.nl>)

The code below simply provides an empty application frame for testing 
purposes with some useful things predefined.  The frame is stored in a global 
variable for easy access.  The main window (pane) of the frame is also
stored in a global variable.

This simplifies testing code.  One can use the window to test
drawing functions simply.  One can also use the frame to test frame
related stuff (commands,...).

The intent of this file is to provide a single testbed.  Instead of 
saying "replace this by your application frame name", one can simply
use this file and tell others "use the clim-tests-frame" from the
library.

To start up the clim-tests-frame, evaluate (start-up-clim-tests-frame) 
in the clim-user package.  Under Genera, you can also type select-symbol-t.

Please contact me for suggestions or modifications that you make
to this file.

Keunen Vincent                  MANEX sprl
manex@applelink.apple.com       rue Wagner, 93
tel: +32 41 380 368             B-4100 Boncelles
fax: +32 41 380 606             Belgium

----------------------------------------------------------------

Example of how to use the clim-tests-frame:

I want to know what draw-circle* does.

0) Make clim-user the current package: (in-package :clim-user)
1) Load this file to define the application frame.
2) Evaluate the following:
   (the clim-test-function is called by the "Test" command
    in the frame):
   (defun clim-test-function ()
      (draw-circle* *the-clim-tests-frame-main-window*
           100 100 50 :filled t))
3) Start up the frame:
   - Evaluate (start-up-clim-tests-frame).
   - Under Genera, you can also type select-symbol-t.

4) Select the "Test" command of your framework to test
   your clim-test-function.

|#

#+Genera
(in-package (find-package "CLIM-USER"))

#-Genera
(in-package :clim-user)


;;;;----------------------------------------------------------------
;;;; Frame definition

(defvar *the-clim-tests-frame* nil)
(defvar *the-clim-tests-frame-main-window* nil)

(define-application-frame clim-tests-frame ()
    ((one-state-variable :initform nil
			 :accessor one-state-variable))
  (:command-table (clim-tests-frame
		    :inherit-from
		    (user-command-table accept-values-pane)))
  (:command-definer t)
  (:panes ((display :application)
	   (menu :command-menu)
	   (interactor :interactor)))
  (:layout ((standard
	      (:column 1
	       (display :rest)
	       (menu :compute)
	       (interactor 1/5))))))

;;;;----------------------------------------------------------------
;;;; Commands

(define-clim-tests-frame-command (com-test :menu "Test") ()
  ;;put your testing code here
  (clim-test-function))

(defun clim-test-function ()
  (draw-circle* *the-clim-tests-frame-main-window*
           100 100 50 :filled t)
  (format *query-io* "~&The test command has been executed."))

(define-clim-tests-frame-command (com-clear :menu "Clear") ()
  (window-clear *the-clim-tests-frame-main-window*))

(define-clim-tests-frame-command (com-exit-clim-tests-frame 
                                  :menu #-mcl "Exit" #+mcl "Quit") ()
  (frame-exit *application-frame*))

;;;;----------------------------------------------------------------
;;;; Starting up the frame

#+Genera
(define-genera-application clim-tests-frame :select-key #\)
;;;This symbol is symbol-t (as in test).  So use select-symbol-t.


(defun start-up-clim-tests-frame ()
  (run-frame-top-level
    (make-application-frame
      'clim-tests-frame
      :parent
      ;;thanks to Oliver Christ <oli@adler.ims.uni-stuttgart.de> for the code below
      #+Lucid (open-root-window
		:clx
		:host (lcl:environment-variable "DISPLAY"))
      #+Allegro-v4.1 (open-root-window
		       :clx
		       :host (system:getenv "DISPLAY"))
      #+MCL          (open-root-window :mcl)
      #+Genera       (open-root-window :sheet)
      ;;Please contact keunen@nrb.be if you modify this source code.
      #-(or Lucid Allegro-v4.1 MCL Genera)
      (warning "Unknown CLIM/LISP combination.  Please modify the
start-up-clim-tests-frame function to your needs."))))

;;;;----------------------------------------------------------------
;;;; For easy access

(defmethod run-frame-top-level :before
		((the-frame clim-tests-frame))
  (setf *the-clim-tests-frame* the-frame)
  (setf *the-clim-tests-frame-main-window*
	(get-frame-pane *the-clim-tests-frame* 'display)))

