
;; Ansatz das def-logical-pathname verhalten vom mac
;; nachzuempfinden
;; bambi, april 1994

;; die idee ist, eine hashtabelle aufzubauen, in der die entsprechungen
;; gespeichert werden.
;; es wird keine globale variable verwendet
;; Achtung: der logische Pfadteil darf nur am anfang des pfades stehen

;; voruebergehend
(defparameter b_logical_pathnames
     (make-hash-table :test #'equalp)
     )

;;; (let ((b_logical_pathnames
;;;           (make-hash-table :test #'equalp))
;;;        )

(defun def-logical-pathname (logical-path original-path)
     (prog1
         (gethash logical-path  b_logical_pathnames)
         (setf (gethash logical-path  b_logical_pathnames)
                 ;; kann ja sein, dass der wieder auf einem logischen fusst
                 original-path)
         )
     )

(defun lp=show-all-logicals ()
     (terpri)
     (maphash #'(lambda (key value)
                             (print key)
                             (format t "~%---> ~s" value))
           b_logical_pathnames
           ))

(defun full-pathname (logical-path &key (error-p nil))
     (labels ((*zerlege_pfad (pfad)
                      (let* ((logischer_anteil (position #\; pfad))
                              )
                          (cond (logischer_anteil
                                       `(,(subseq pfad 0 logischer_anteil)
                                         ,(subseq pfad (1+ logischer_anteil)))
                                       )
                                   (t (list nil pfad))
                                   )))
                  (*transform_mac->dos (pfad-string)
                     (loop
                         (if (position #\: pfad-string :start 2)
                            (replace pfad-string "\\\\"
                                :start1 (position #\: pfad-string :start 2)
                                :end1 (1+ (position #\: pfad-string :start 2)))
                            (return pfad-string)
                            ))
                     )
                  )
         ;; wenn ein richtiger pfadname, dann mache nichts
         (if (pathnamep logical-path)
            logical-path
            (let ((pfad-liste (*zerlege_pfad (*transform_mac->dos logical-path)))
                   )
                (cond ((and (first pfad-liste)
                                  (gethash (first pfad-liste) b_logical_pathnames)
                                  )
                          (concatenate 'string
                              (full-pathname (gethash (first pfad-liste) b_logical_pathnames))
                              (or (second pfad-liste) ""))
                          )
                         ((first pfad-liste)
                          (when error-p
                               (error "~a; ist kein logischer pfad" (first pfad-liste))
                               ))
                         (t (second pfad-liste))
                         ))
            )))
;    )
