;; implementierung des pop-up-menus
;; *b-pop-up-menu* und *b-menu-item*

;; stefan & karsten, 3.6.93


(defclass *b-menu* (pop-up-menu)
      ()
     )

(defmethod about-to-show-menu :before (fenster (ich *b-menu*))
     (menu-update ich))

(defmethod menu-update ((ich *b-menu*))
     (dolist (item (menu-items ich))
          (let ((objekt (menu-item-to-clos-objekt item)))
              (when objekt
                   (menu-item-update objekt))))
     )


(defclass *b-pop-up-menu* (*b-menu*)
      ()
     )

(defmethod b=pop-up-menue-aufklappen (view ich &optional pos)
     (if pos
        (pop-up-menu  ich view
             (subtract-points pos
               (view-scroll-position view)))
          (pop-up-menu  ich view))
        )

(defmethod add-menu-items ((ich *b-menu*) &rest menu-itemss)
     (update-menu ich (append (menu-items ich) menu-itemss))
     )

(defmethod remove-menu-items ((ich *b-menu*) &rest menu-itemss)
     (update-menu ich (remove-if #'(lambda (x)
                                                          (member x menu-itemss))
                                      (menu-items ich)))
     )

(defun menu-deinstall (menu)
     ;Der bloede Compiler erlaubt nur
     (let ((das-tatsaechliche (finde-menu menu)))
         (when das-tatsaechliche
     (remove-from-menu
         (window-menu *unser-haupt-fenster*)
         das-tatsaechliche))))

(defmethod menu-enable ((ich *b-menu*))
     (set-menu-item-available-p (finde-menu ich) t)
     )


(defmethod menu-disable ((ich *b-menu*))
      (set-menu-item-available-p (finde-menu ich) nil)
     )

(defun finde-menu (menu)
     (if (menu-item-p menu)
        menu
     (dolist (strukt (menubar))
          (when (eq menu (menu-item-value strukt))
               (return strukt)))))

(defun menu-installed-p (menu)
     (dolist (strukt (menubar))
          (when (eq menu (menu-item-value strukt))
               (return strukt))))

(defun menu-install (menu)
     (add-to-menu
           (window-menu *unser-haupt-fenster*)
          (test-menu menu)))

(defun set-menubar (was)
     (unless (window-menu *unser-haupt-fenster*)
          (open-stream 'menu-bar *unser-haupt-fenster* :io))
     (dolist (menu (menubar))
             (menu-deinstall menu))
     (when was
        (dolist (menu was)
             (menu-install menu))
        ))

(defun menubar ()
     (let ((bar (window-menu *unser-haupt-fenster*)))
         (when bar
              (menu-items 
                    bar))))

(defvar *default-menubar*
   #+:acl2a
   *lisp-menu-bar*
   #-:acl2a
  (menubar)
   )

(defun test-menu (menu)
     "In die Menueleiste koenne nur Items"
     (if (typep menu 'menu-item)
        menu
        (make-menu-item
              :title (stream-title menu)
              :value menu)))

(defun draw-menubar-if ()
     T)

(defclass *windows-menu* (*b-pop-up-menu*)
      ()
     )

(defmethod menu-update ((ich *windows-menu*))
     (let ((fenster 
                (remove-if-not
                    #'(lambda(fenster)
                           (eq (window-state fenster) :normal))
                (windows *unser-haupt-fenster*))))
         ;alle alten raus neue rein
         (update-menu ich
              (mapcar #'(lambda(fenster)
                                   (m->a=erzeuge-menu-item
                                        '*b-menu-item*
                                        :menu-item-title (window-title fenster)
                                        :menu-item-action
                                        #'(lambda()
                                               (select-window fenster))))
                    fenster))))

#|
(defparameter
     test (m->a=erzeuge-menu '*windows-menu*
                :menu-title "Fenster"
                 ))
(menu-install test)
|#

(defclass *b-menu-item* ()
      ((das-strukt :initarg :das-strukt
        :accessor macemu-das-strukt)
       (menu-item-title :initarg :menu-item-title
             :initform "Kein Titel" :accessor bmi-menu-item-title)
       (value :initarg :menu-item-value
            :initarg :menu-item-wert
            :initarg :menuepunkt-wert
            :initform 'irgendwas
            :accessor bmi-value)
       (menu-item-action :initarg :menu-item-action
        :initform #'(lambda ()
                             (b=nachricht "Keine Aktion angegeben.")
                             )
        :accessor bmi-menu-item-action)
       (disabled :initarg :disabled :accessor bmi-disabled :initform nil)
       (command-key :initarg :command-key :accessor bmi-command-key :initform nil)
       )
     )

(defun menu-item-to-clos-objekt (menu-item)
     (getf (menu-item-plist menu-item) :clos-objekt))

(defmethod menu-item-update ((ich *b-menu-item*))
     )

(defmethod menu-item-enable (strukt)
     (set-menu-item-available-p strukt t))

(defmethod menu-item-enable ((ich *b-menu-item*))
    (menu-item-enable (macemu-das-strukt ich)))

(defmethod menu-item-disable (strukt)
     (set-menu-item-available-p strukt nil))

(defmethod menu-item-disable ((ich *b-menu-item*))
    (menu-item-disable (macemu-das-strukt ich)))


(defmethod set-menu-item-title-portable (strukt title)
     (set-menu-item-title strukt title))

(defmethod set-menu-item-title-portable ((ich *b-menu-item*) title)
    (set-menu-item-title-portable (macemu-das-strukt ich) title))

(defmethod set-menu-item-check-mark ((ich *b-menu-item*) was)
    (set-menu-item-check-mark (macemu-das-strukt ich) was))


(defmethod set-menu-item-check-mark (strukt was)
     (set-menu-item-selected-p strukt was))

#|



(defclass *test-menu-item (*b-menu-item*)
      ())

(defparameter *test* nil)
(setq *test* t)
 (setq *test* nil)

(defmethod menu-item-update ((ich *test-menu-item))
     (if *test*
        (menu-item-enable ich)
        (menu-item-disable ich))
     )

(setq der
      (m->a=erzeuge-menu
           '*b-menu*
           :menu-title "Test"
           :menu-items
           (list
             (setq haus  (M->A=ERZEUGE-MENU-ITEM
                   '*test-menu-item
                   :menu-item-title "Der"
                   :command-key #\d)))))

 (menu-install der)
 (menu-deinstall der)
|#