#|
*********************************************************************************************************************
*********************************************************************************************************************
****                                                                                                             ****
****                                       *b-namen-suchen-window*                                               ****
****                                                                                                             ****
****                                                                                                             ****
****      Autor: Norbert Hoffmann                                       Erstellt: November 1991                  ****  
****                                                                                                             ****
****                                                                                                             ****
*********************************************************************************************************************
****                                                                                                             ****
****                      Unterobjekt von *b-button-window*  *b-window*                                          ****
****                                                                                                             ****
*********************************************************************************************************************
*********************************************************************************************************************


******************************* Stand der Version *******************************************************************
Unterschiede zur Spezifikation:
-Enthlt objekttypauswahl nicht key-wort :trennen, werden die objekttypen in einer Spalte angeordnet
-default-Wert fr breite-objektzeilen ist 425
-Fenstergren kleiner als 120 horizontal und 205 vertikal werden aus sthetischen Grnden ignoriert (siehe
initialize-instance)

Unschnheiten:
-Nur wenn sequence-dialog-item Objekte enthlt, erscheint, nachdem die Fenstergre verndert wurde, der untere Strich
des Objektfeldes (sequence-dialog-item) nicht mehr vollstndig.
Erst beim reaktivieren des Fensters ist er wieder komplett gezeichnet.

Sonstiges:
Wird in der init-list  window-show  T  ----> Fenster auch whrend Aufbau sichtbar
                                   Nil ----> Fenster bleibt unsichtbar
                               default ----> Fensteraufbau unsichtbar dann Fenster sichtbar

Achtung, wenn in der sequence (Objektfeld) Duplikate enthalten sind, gibts Probleme beim deselektieren

Da alle Schnittstellenfunktionen und f-Funktionen Objekt-ids als Parameter erhalten, werden in den slots
"angezeigte-objekte" und "selektierte-objekte" die entsprechenden ids gehalten, es reicht nicht auf die
table-sequence oder den slot "selektierte-objekte" der table-sequence (in "objektfeld") zuzugreifen.


*********************************************************************************************************************
|#
(defclass *b-namen-suchen-window* (*b-button-window*)  ;vorher: (*b-button-window* *b-window*)
  (
   ; groesse
   (window-size :initarg :window-size)
   ; titel
   (window-title :initarg :window-title :initform (b=s :objektnamen_suchen))
   ; schriftstil fuer sequence und buttons
   (schrift :initarg :schrift :initform b_Normalschrift)
   ; sichtbare zeilen in der scrollbaren anzeige der sequence
   (anzahl-sichtbarer-objektzeilen :initarg :anzahl-sichtbarer-objektzeilen :initform 10)
   ; breite der der scrollbaren anzeige der sequence
   (breite-objektzeilen :initarg :breite-objektzeilen :initform 425)
   ; ueberschrift des b-static-text, in dem der suchtext eingegben wird
   (anfangsbuchstaben-oder-teilwort-text :initarg :anfangsbuchstaben-oder-teilwort-text
    :initform (b=s :Teilwort))
   ; liste der objekttypen, die die elemente der zu durchsuchenden sequence einschraenken
   (Objekttypauswahl :initarg :Objekttypauswahl :initform nil) ;kann Keyword :trennen enthalten
   ; abstand der einzelnen check-boxes/radio-buttons
   (horizontaler-Abstand-Objekttyp-Auswahlelemente :initarg :horizontaler-Abstand-Objekttyp-Auswahlelemente :initform 20)
   ; bezieht sich nur auf die objekttypen
   (Objekttypauswahl-Selektionstyp :initarg :Objekttypauswahl-Selektionstyp :initform :single)
   ; erzeugt namen der check-boxes/radio-buttons
   (f-Objekttypauswahl-Text :initarg :f-Objekttypauswahl-Text
      :initform 'b=erzeuge-string)
   ; voreinstellung der objektauswahl   
   (Objekttypauswahl-Voreinstellung :initarg :Objekttypauswahl-Voreinstellung)
   ; text der auf dem button steht, der alle vorhandenen objekte in die sequence aufnimmt
   (alle-button-text :initarg :alle-button-text :initform (b=s :alle))
   ; such-funktion die auf die sequence angewendet wird
   (f-objekte-suchen :initarg :f-objekte-suchen :initform nil) 
   ; liefert anzuzeigenden text fuer die objekte der sequence
   (f-objekttext :initarg :f-Objekttext :initform 'b=erzeuge-string)
   ; liefert hintergrundfarbe fuer die objekte der sequence
   (f-Objekt-Hintergrundfarbe :initarg :f-Objekt-Hintergrundfarbe)
   ; liefert hintergrundfarbe fuer die check-boxes/radio-buttons
   (f-Objekttyp-Hintergrundfarbe :initarg :f-Objekttyp-Hintergrundfarbe)
   ;
   (f-Objekttyp :initarg :f-Objekttyp)
   ; selektionstyp der sequence
   (selektionstyp :initarg :Selektionstyp :initform :single)
   ;
   (f-pop-up-menue :initarg :f-pop-up-menue :initform nil)
   ;   
   (f-objekt-selektierbar-p :initarg :f-objekt-selektierbar-p :initform nil)
   (f-cursor :initarg :f-cursor :initform nil)
   (Objekttypauswahl-editierbar-p :initarg :Objekttypauswahl-editierbar-p :initform T)
   (f-Objekttypauswahl-editierbar-p :initarg :f-Objekttypauswahl-editierbar-p :initform nil)
   (f-objekt-wurde-selektiert :initarg :f-objekt-wurde-selektiert :initform nil)
   (f-objekt-wurde-deselektiert :initarg :f-objekt-wurde-deselektiert :initform nil)
   (f-objekt-wurde-selektiert-oder-deselektiert 
    :initarg :f-objekt-wurde-selektiert-oder-deselektiert :initform nil)
   (f-doppelklick-objekt :initarg :f-doppelklick-objekt :initform nil)
   (f-einfachklick-objekt :initarg :f-einfachklick-objekt :initform nil)
   (markierte-objekttypen :initform nil) 
   (angezeigte-objekte :initform nil)   ;Objektids
   (selektierte-objekte :initform nil)  ;Objektids
   (old-size :initform nil)
   (basis-objektfeld :initform #+ :ccl-2 120 #+ :aclpc 140)     ;vertikalposition des objektfeldes in pixel vom oberen rand des dialogfensters
                                        ;sie kann durch Objekttypauswahl evtl. verschoben werden
   (basis-suchen-button :initform 330)  ;horizontalposition von suchen- und alle-button
                                        ;sie kann durch Objekttypauswahl evtl. verschoben werden
   ; der button, der alle objekte in die sequence aufnimmt   
   (alle-button :initform nil) 
   ; der b-static-text, in dem der such-text eingegeben wird
   (stringfeld :initform nil)
   ; der button, der die suche veranlasst
   (suchenbutton :initform nil) 
   ; die eigentliche sequence
   (objektfeld :initform nil)
   (gepufferte-init-list :accessor nh-gepufferte-init-list)
   )
  (:default-initargs
    :window-title (b=s :objektnamen_suchen)
    :window-type :document-with-grow
    :view-position :centered
    ))


;--------------------------------------------------------------------------------------------------------------
(defmethod initialize-instance ((self *b-namen-suchen-window*) &rest init-list)
     (apply #'call-next-method
          self
          (setf (nh-gepufferte-init-list self)
                  (init-list-default init-list
                      :view-size (getf init-list :window-size
                                            ; ist keine window-size angegeben,
                                            ; horizontal: default fr breite-objektzeilen + 15 fr scroll-bar
                                            ; vertikal: default bei 10 sichtbaren Objektzeilen evtl. +40 fr buttons
                                            (make-point 440
                                                  (+ 275 (if (getf init-list :buttons)
                                                                #+ :ccl-2 40 #+ :aclpc 80 0))))
                      :window-show NIL
                      :view-font (getf init-list :schrift b_Normalschrift)))))

 (defmethod initialize-instance :after ((self *b-namen-suchen-window*) &rest banane)
      (let ((init-list (nh-gepufferte-init-list self)))
     ; default-Wert fr slot Objekttypauswahl-Voreinstellung setzen
     ;nach call-next-method, da auf slot Objekttypauswahl-Voreinstellung zugegriffen wird
     (unless (getf init-list :Objekttypauswahl-Voreinstellung)
          (setf (slot-value self 'Objekttypauswahl-Voreinstellung)
                   (cond ((equal (slot-value self 'Objekttypauswahl-Selektionstyp) :single)
                               (car (slot-value self 'Objekttypauswahl)))
                              ((equal (slot-value self 'Objekttypauswahl-Selektionstyp) :multiple)
                               (remove :trennen (slot-value self 'Objekttypauswahl)))
                              (T NIL))))
     ;f-Objekttypauswahl-editierbar-p wird bei jedem Aktivieren des Fensters wieder aufgerufen
     (when (slot-value self 'f-Objekttypauswahl-editierbar-p)
           (setf (slot-value self 'Objekttypauswahl-editierbar-p)
                    (funcall (slot-value self 'f-Objekttypauswahl-editierbar-p))))
     (set-view-size self
          (make-point
                (if (getf init-list :breite-objektzeilen)
                   ; ist ein Wert fr breite-objektzeilen angegeben, wird die Horizontalkomponente der
                   ; Fenstergre neu berechnet
                   (+ 15 (slot-value self 'breite-objektzeilen))
                   (if (< (point-h (view-size self)) 120)
                      120 ; kleinste sinnvolle Fenstergre horizontal
                      (point-h (view-size self))))
                (if (getf init-list :anzahl-sichtbarer-objektzeilen)
                   ; ist ein Wert fr anzahl-sichtbarer-objektzeilen angegeben, wird die 
                   ; Vertikalkomponente der Fenstergre neu berechnet
                   (+ 135 (* (slot-value self 'anzahl-sichtbarer-objektzeilen) #+ :ccl-2 14 #+ :aclpc 28)
                       (if (getf init-list :buttons) ;buttons vorhanden
                          ;then fenster grer
                          #+ :ccl-2 40 #+ :aclpc 80
                          ;else
                          0))
                   (if (< (point-v (view-size self)) 205)
                      205 ;kleinste sinnvolle Fenstergre vertikal
                      (point-v (view-size self))))))
  (setf (slot-value self 'old-size) (view-size self))
  (setf (slot-value self 'basis-suchen-button) (- (point-h (view-size self)) 115))
  (nh-erzeuge-typ-buttons self)
  (when (and (slot-value self 'Objekttypauswahl)              ; kein Alle-Button, falls keine Objekttypauswahl
             (if (member :alle-button-text init-list)         ;              oder Text fr Alle-Button nil
               (getf init-list :alle-button-text)
               t))
    (nh-erzeuge-alle-button self))
  (nh-erzeuge-fensterinhalt self init-list)
  (minimale-fenstergroesse-setzen self (make-point (+ (slot-value self 'basis-suchen-button) 110) ;horizontal
                                                   (+ (slot-value self 'basis-objektfeld)
                                                      45  ;15 fr scrollbar + 30 fr zwei zellen, die mind. sichtbar bleiben
                                                      (if (buttons self)
                                                        #+ :ccl-2 40 #+ :aclpc 80
                                                        0))))       ;vertikal
  (set-default-button self (slot-value self 'suchenbutton))
  (when (or (not (member :window-show init-list))       ;default-mig wird Fenster nach Aufbau sichtbar
            (getf init-list :window-show))              ;auer in init-list ist window-show = NIL
        (window-show self))     ))

;---------------------------------------------------------------------------------------------------------------
(defmethod nh-erzeuge-typ-buttons ((self *b-namen-suchen-window*))
  (do* ((typenauswahl (slot-value self 'Objekttypauswahl) (cdr typenauswahl))
        (typ (car typenauswahl) (car typenauswahl))
        (neue-spalte-p (equal typ :trennen) (equal typ :trennen))
        (max-length-typ (length (funcall (slot-value self 'f-Objekttypauswahl-Text) typ))
                         ;laenge des laengsten objekttyp-bezeichners einer spalte
                         ;um den abstand der naechsten spalte zu bestimmen
                        (if (not neue-spalte-p)
                          ;then
                          (if (> (length (funcall (slot-value self 'f-Objekttypauswahl-Text) typ)) max-length-typ)
                            ;then 
                            (length (funcall (slot-value self 'f-Objekttypauswahl-Text) typ))
                            ;else
                            max-length-typ)
                          ;else
                          max-length-typ))
        (position (make-point 20 #+ :ccl-2 60 #+ :aclpc 60)  ;position (innerhalb des Fensters) des nchsten objekttyps (beginnend oben links)
                  (make-point (+ (point-h position)
                                 (if neue-spalte-p
                                   ;then addiere zur horizontalposition
                                   (+ (*  #+ :ccl-2 8 #+ :aclpc 14 max-length-typ)      ;Buchstabenbreite von 8 Pixel angenommen
                                      (slot-value self 'horizontaler-Abstand-Objekttyp-Auswahlelemente))
                                   ;else horizontalpositition bleibt (addiere 0)
                                   0))
                              (if neue-spalte-p (- #+ :ccl-2 60 #+ :aclpc 60 #+ :ccl-2 16 #+ :aclpc 25)       ;vertikaler abstand zwischen objekttypen = 16
                                  (+ (point-v position) #+ :ccl-2 16 #+ :aclpc 25)))))
       ((null typenauswahl) nil)

    (if (not neue-spalte-p)
      ;then
      (progn
        (cond ((> (point-v position) (- (slot-value self 'basis-objektfeld) 20))  ;falls zu wenig platz in vertikalrichtung
               (setf (slot-value self 'basis-objektfeld)                          ; platz schaffen
                     (+ (slot-value self 'basis-objektfeld) 20))
               (set-view-size self (point-h (view-size self)) (+ 20 (point-v (view-size self)))))
              ((> (+ (point-h position) (*  #+ :ccl-2 8 #+ :aclpc 14 max-length-typ) 20)
                  (slot-value self 'basis-suchen-button))      ; falls zu wenig platz in horizontalrichtung
               (set-view-size self                             ; platz schaffen
                              (+ (point-h (view-size self))
                                 (- (+ (point-h position) (* #+ :ccl-2 8 #+ :aclpc 14 max-length-typ) 20)
                                    (slot-value self 'basis-suchen-button)))
                              (point-v (view-size self)))
               (setf (slot-value self 'basis-suchen-button) (- (point-h (view-size self)) 110)))
              (t nil))
        (cond ((equal (slot-value self 'Objekttypauswahl-Selektionstyp) :single)
               (nh-erzeuge-radio-button self position typ))
              ((equal (slot-value self 'Objekttypauswahl-Selektionstyp) :multiple)
               (nh-erzeuge-check-box self position typ))
              (T NIL)))
      ;else   Typ = :trennen, d.h. neue Spalte beginnen
       (setq max-length-typ 0))))

;-------------------------------------------------------------------------------------------------------------------
(defmethod nh-erzeuge-radio-button ((self *b-namen-suchen-window*) position typ)
     (when (equal  typ (slot-value self 'Objekttypauswahl-Voreinstellung))
           (setf (slot-value self 'markierte-objekttypen)
                    (cons typ (slot-value self 'markierte-objekttypen))))
          (add-subviews  self 
          (m->a=erzeuge-dialog-item '*b-radio-button-dialog-item*
           :radio-button-pushed-p (equal typ 
                                                          (slot-value self 'Objekttypauswahl-Voreinstellung))
           :view-font (slot-value self 'schrift)
           :view-position position
           #+ :aclpc :view-size #+ :aclpc (make-point (* 18 (+ 1 (length (funcall (slot-value self 'f-Objekttypauswahl-Text) 
                                                                                                                       typ))))   30)
           #+ :aclpc :radio-button-cluster  #+ :aclpc 'eg-cluster
           :dialog-item-enabled-p (slot-value self  'Objekttypauswahl-editierbar-p)
           :dialog-item-text (funcall (slot-value self 'f-Objekttypauswahl-Text) typ))))

;-------------------------------------------------------------------------------------------------------------------
(defmethod nh-erzeuge-check-box ((self *b-namen-suchen-window*) position typ)
     (when (member typ (slot-value self 'Objekttypauswahl-Voreinstellung))
           (setf (slot-value self 'markierte-objekttypen)
                    (cons typ (slot-value self 'markierte-objekttypen))))
     (add-subviews self 
          (m->a=erzeuge-dialog-item '*b-check-box-dialog-item*
           :check-box-checked-p (member typ 
                                                         (slot-value self 'Objekttypauswahl-Voreinstellung))
           :view-font (slot-value self 'schrift)
           :view-position position
           #+ :aclpc :view-size #+ :aclpc (make-point (* 18 (+ 1 (length (funcall (slot-value self 'f-Objekttypauswahl-Text) 
                                                                                                                       typ))))   30)
           :dialog-item-enabled-p (slot-value self 'Objekttypauswahl-editierbar-p)
           :dialog-item-text (funcall (slot-value self 'f-Objekttypauswahl-Text) typ))))

;-------------------------------------------------------------------------------------------------------------------
(defmethod nh-erzeuge-alle-button ((self *b-namen-suchen-window*))
     (add-subviews  self 
          (setf (slot-value self 'alle-button)
                   (m->a=erzeuge-dialog-item '*b-button*
                    :view-width 100
                    :view-position (make-point ;(slot-value self 'basis-suchen-button)
                                                   (- (point-h (view-size self)) 115)
                                                   #+ :aclpc 110 #+ :ccl-2 90)
                                      :dialog-item-text (slot-value self 'alle-button-text)
                                      :dialog-item-action
                                      #'(lambda (self)
                                          (nh-suchen-button-action (view-container self) ""))
                                          ))))

;-------------------------------------------------------------------------------------------------------------------
#+ :aclpc
(defmethod find-dialog-item ((self *b-namen-suchen-window*) text)
     (let ((dialogs (subviews self)))
         (find text dialogs :key #'(lambda (dialog) (dialog-item-title dialog)))))


