#|
********************************************************************************
********************************************************************************
*****                                                                      *****
*****                        Dialogfunktion b=eingabe                      *****
*****                                                                      *****
*****    Autor:                                    Erstellt: ????          *****
*****           Karsten Poeck                     Geaendert:  ????         *****
*****                                                                      *****
********************************************************************************
********************************************************************************
|#

#+:ccl-2
(defclass *b-Eingabe-Fenster* (*b-Selbstantwort-mixin* dialog)
  ())

#+:ccl-2
(defun b=eingabe (&key (Ueberschrift (b=s :eingabe)) ;noch undefiniert
                       (Initial-text "")
                       (Abbrechen-text (b=s :abbrechen))
                       (Ok-text (b=s :ok))
                       (Fensterbreite 300)
                       (Fensterposition b_dialogfenster-position-unten)
                       (schrift b_chicagoschrift)
                       (eingabefeld-schrift b_chicagoschrift)
                       (Throw-to-cancel t)
                       (sekunden nil))
  "Bringt eine Dialog, in dem der Benutzer einen string angeben oder
   bearbeiten kann, aehnlich wie get-string-from-user. Die Ausgabe ist
   der eingegebene String bzw. :cancel"
  
  #|
   Eingabeparameter:
   :Ueberschrift         Text der Ueberschrift, auch mehrzeilig,
                        muss aber per Hand umgebrochen werden.
   :Initial-text        Vorbelegungstext der Eingabe
   :Abbrechen-text      Text des Abbrechen-knopfs
                        nil bedeutet, dass keiner erscheint
   :Ok-text             Text des OK-knopfs
   :Fensterbreite       Gesamtbreite des Dialogs 
   :schrift             Schriftart fuer die Dialogelemente
   :eingabefeld-schrift Schrift nur zur Stringeingabe
   :Fensterposition     Position des Fensters (ein Punkt)
   :Throw-to-cancel     t bedeutet, dass beim Abbrechen ein Throw nach :cancel erfolgt
                        nil bedeutet, dass beim Abbrechen nil zurueckgeliefert wird
   Ausgabe
   Falls mit OK bestaetigt  wurde, der Eingabestring
   Falls mit Abbrechen beendet wurde nil bzw throw :cancel, je nach
                               Wert von Throw-to-cancel
   
|#
  (let* (Ueberschrift_item
         eingabe_item
         (knopfbreite 90)
         (knopfhoehe 20) 
         (eingabe_hoehe)
         (eingabe_y)
         (rand_knopf_abstand 10)
         (abstand_eingabe_knopf 20)
         (Ueberschrift_breite (- fensterbreite abstand_eingabe_knopf (* 2 rand_knopf_abstand) knopfbreite)))
    (when (< fensterbreite 
             (+ knopfbreite
                (* 3 rand_knopf_abstand)))
      (setq fensterbreite
            (+ 100 ;mindestbreite editable text
               knopfbreite (* 2 rand_knopf_abstand) abstand_eingabe_knopf)))
    (if (and (boundp 'b_eingabe-fenster)
             (wptr b_eingabe-fenster))
      ;alle items loeschen
      (progn
        (sekunden-setzen b_eingabe-fenster nil)
        (apply 'remove-subviews b_eingabe-fenster (subviews b_eingabe-fenster))
        (set-view-font b_eingabe-fenster schrift)
        (set-view-position b_eingabe-fenster Fensterposition)
        (sekunden-setzen b_eingabe-fenster sekunden))
      (setq  b_eingabe-fenster
             (make-instance '*b-Eingabe-Fenster*
                    :window-type :double-edge-box
                    :view-position fensterposition
                    :view-font schrift 
                    :window-show nil
                    :sekunden sekunden)))
    (setq Ueberschrift_item
          (b=static-text Ueberschrift Ueberschrift_breite 10 10 :font schrift))
    (add-subviews b_eingabe-fenster Ueberschrift_item)
    (setq eingabe_y (+ (point-v (view-size Ueberschrift_item))
                       10 ; Beginn Ueberschrift
                       20 ; abstand Ueberschrift Eingabe_item
                       ))
    (setq eingabe_item
          (make-instance 'editable-text-dialog-item
                 :dialog-item-text initial-text
                 :view-font eingabefeld-schrift
                 :view-position (make-point 10 eingabe_y)))
    (add-subviews b_eingabe-fenster eingabe_item)
    (set-view-size eingabe_item
                   (make-point (point-h (view-size Ueberschrift_item))
                               (point-v (view-size eingabe_item))))
    (setq eingabe_hoehe (point-v (view-size eingabe_item)))
    
    (let* (  (fenster_hoehe (+ eingabe_y eingabe_hoehe rand_knopf_abstand))
             (ok_position 
              (make-point (- Fensterbreite rand_knopf_abstand knopfbreite)
                          (- fenster_hoehe rand_knopf_abstand knopfhoehe)))
             (abbrechen_position
              (make-point (- Fensterbreite rand_knopf_abstand knopfbreite)
                          (- fenster_hoehe (* 2 (+ rand_knopf_abstand knopfhoehe)))))
             abbrechen_item ok_item)
      (when abbrechen-text
        (setq abbrechen_item
              (make-instance '*b-button*
                     :view-size (make-point knopfbreite knopfhoehe)
                     :dialog-item-text abbrechen-text
                     :dialog-item-action
                     #'(lambda(self)
                         (declare (ignore self))
                         (if throw-to-cancel
                           (return-from-modal-dialog :cancel)
                           (return-from-modal-dialog nil)))
                     :view-position abbrechen_position))
        (add-subviews b_eingabe-fenster abbrechen_item))
      (setq ok_item
            (make-instance '*b-button*
                   :view-size (make-point knopfbreite knopfhoehe)
                   :dialog-item-text ok-text
                   :dialog-item-action
                   #'(lambda(self)
                       (declare (ignore self))
                       (return-from-modal-dialog (dialog-item-text eingabe_item)))
                   :view-position ok_position))
      (add-subviews b_eingabe-fenster ok_item)
      (set-default-button b_eingabe-fenster ok_item)
      (set-view-size b_eingabe-fenster fensterbreite (if sekunden (+ fenster_hoehe 20) fenster_hoehe))
      (set-view-position b_eingabe-fenster Fensterposition)
      (with-cursor *arrow-cursor*
        (window-select b_eingabe-fenster)
        (modal-dialog b_eingabe-fenster nil))
      );let
    );let
  )

#|
(b=eingabe  :Ueberschrift "Eingabe von einem Objekt")
(b=eingabe  :Ueberschrift "Eingabe von 4981 234987 123498 qwerlhlqwjeh qwelh lkweh
ilasdjkAHASDK aSOeLDh aSOeKH oeASKh oeASKH OeASKH   123498 1234 987 sdwf sadf asdf "
            :fensterbreite 400
          ;  :fensterposition b_dialogfenster-position-oben
            :schrift `("monaco" 12)
            :eingabefeld-schrift '("Chicago" 90)
            :throw-to-cancel nil)
(b=eingabe  :abbrechen-text nil 
            :Ueberschrift (b=konkateniere-nach-string "Eingabe eines Attributs " #\newline "Bitte:")
            :initial-text "p_jjj"
            :fensterbreite 500)

|#


#+:aclpc
(defun b=eingabe (&key (Ueberschrift (b=s :eingabe)) ;noch undefiniert
                                  (Initial-text "")
                                  (Abbrechen-text (b=s :abbrechen))
                                  (Ok-text (b=s :ok))
                                  (Fensterbreite 300)
                                  (Fensterposition nil) ;; b_dialogfenster-position-unten
                                  (schrift b_chicagoschrift)
                                  (eingabefeld-schrift b_normalschrift)
                                  (Throw-to-cancel t)
                                  (sekunden nil))
     "Bringt eine Dialog, in dem der Benutzer einen string angeben oder
bearbeiten kann, aehnlich wie get-string-from-user. Die Ausgabe ist
der eingegebene String bzw. :cancel"
     (declare (ignore Fensterbreite Fensterposition schrift eingabefeld-schrift
                       sekunden
                       ))
     (let (erg)
         (multiple-value-bind (string1 string2-egal button-number)
          (pop-up-string-dialog *unser-haupt-fenster*
               nil
               ueberschrift
               question-icon
               initial-text ok-text (or abbrechen-text (b=s :abbrechen))
               )
               (declare (ignore string2-egal))
          (cond ((= button-number 2) ;; abbrechen
                    (when throw-to-cancel
                         :cancel))
                   (t string1)
                   ))
         ))
                       