#+ :aclpc
(defclass *b~fenster_such_mixin* ()
       ())

#+ :aclpc
(defclass *b-selbstantwort-mixin* ()
       ())

#+ :aclpc
(defmethod sekunden-setzen ((ich *b-selbstantwort-mixin*) sekunden)
     nil)

#+ :aclpc
(defclass eg-single (single-item-list mac-dialog-item-mixin)
    ())

#+ :aclpc
(defmethod cell-select ((ich eg-single) h &optional v)
   (unless v
      (setq v (point-v h)))
   (set-dialog-item-value ich
      (nth v (dialog-item-range ich))))

#+ :aclpc
(defmethod selected-cells ((ich eg-single) )
     ;; wert -> koordinate -> liste, h = 0
     ;; dialog-item-value -> suche position -> v
     (let ((v (position (dialog-item-value ich) (dialog-item-range ich))))
         (when v
               (list (make-point 0 v)))))
     
#+ :aclpc
(defclass eg-multi (multi-item-list mac-dialog-item-mixin)
    ())

#+ :aclpc
(defmethod cell-select ((ich eg-multi) h &optional v)
   (unless v
      (setq v (point-v h)))
   (unless  
       ;; teste ob element schon gesetzt ist
       (find (nth v (dialog-item-range ich)) (dialog-item-value ich))
      (set-dialog-item-value ich
         (cons (nth v (dialog-item-range ich)) (dialog-item-value ich)))))

#+ :aclpc
(defmethod selected-cells ((ich eg-multi) )
   ;; wert -> koordinate -> liste, h = 0
   ;; dialog-item-value -> suche position -> v
   (mapcar #'(lambda (item) (make-point 0 (position item (dialog-item-range ich))))
      (dialog-item-value ich)))



#+ :aclpc
(defmethod selektierte-objekte  ((ich eg-single))
     (when (dialog-item-value ich)
           (list (first (dialog-item-value ich)))))
#+ :aclpc
(defmethod selektierte-objekte  ((ich eg-multi))
     (mapcar #'(lambda (paar) (first paar)) (dialog-item-value ich)))

#+ :aclpc
(defmethod set-table-dimensions 
       ((ich eg-single) h &optional v)
     h v)
#+ :aclpc
(defmethod set-table-dimensions 
       ((ich eg-multi) h &optional v)
     h v)

#+ :aclpc
(defmethod set-table-sequence ((ich eg-single) range)
     (set-dialog-item-range ich range))
#+ :aclpc
(defmethod set-table-sequence ((ich eg-multi) range)
     (set-dialog-item-range ich range))

#+ :aclpc
(defmethod table-sequence ((ich eg-single))
     (dialog-item-range ich))
#+ :aclpc
(defmethod table-sequence ((ich eg-multi))
     (dialog-item-range ich))

#+ :aclpc
(defmethod cell-deselect ((ich eg-single) item &optional v)
     (set-dialog-item-value ich (remove item (dialog-item-value ich) :count 1
                                                      :test #'(lambda (element) (eq element item)))))
#+ :aclpc
(defmethod cell-deselect ((ich eg-multi) item &optional v)
     (set-dialog-item-value ich (remove item (dialog-item-value ich) :count 1
                                                      :test #'(lambda (element) (eq element item)))))

#+ :aclpc
(defmethod alles-deselektieren ((ich eg-single))
    (set-dialog-item-value ich ()))
#+ :aclpc
(defmethod alles-deselektieren ((ich eg-multi))
     (set-dialog-item-value ich ()))

#+ :aclpc
(defmethod objekt-selektieren ((ich eg-single) objekt)
     ;selektiert erstes objekt, das gefunden wird
     (when objekt
           (let ((pos (position objekt (dialog-item-range ich) :key 'first)))
               (when pos
                     (set-dialog-item-value ich  (nth pos (dialog-item-range ich)))))))
#+ :aclpc
(defmethod objekt-selektieren ((ich eg-multi) objekt)
     ;selektiert erstes objekt, das gefunden wird
     (when objekt
           (let ((pos (position objekt (dialog-item-range ich) :key 'first)))
               (when pos
                     (unless (find objekt (dialog-item-value ich) :key 'first)
                          (set-dialog-item-value ich  (cons (nth pos (dialog-item-range ich))
                                                                       (dialog-item-value ich))))))))

#+ :aclpc
(defmethod objekt-deselektieren ((ich eg-single) objekt)
     ;deselektiert erstes objekt, das gefunden wird
     (when objekt
           (when (equal objekt (first (dialog-item-value ich)))
                 (set-dialog-item-value ich  ()))))
#+ :aclpc
(defmethod objekt-deselektieren ((ich eg-multi) objekt)
     ;deselektiert erstes objekt, das gefunden wird
     (when objekt
           (when (find objekt (dialog-item-value ich)  :key 'first )
                 (set-dialog-item-value ich  (remove objekt (dialog-item-value ich) :key 'first)))))
     
#+ :aclpc
(defmethod objekte-selektieren ((ich eg-single) objekt-liste)
     (when objekt-liste
           (mapc #'(lambda (objekt) (objekt-selektieren ich objekt)) objekt-liste)))
#+ :aclpc
(defmethod objekte-selektieren ((ich eg-multi) objekt-liste)
     (when objekt-liste
           (mapc #'(lambda (objekt) (objekt-selektieren ich objekt)) objekt-liste)))

#+ :aclpc
(defmethod objekte-deselektieren ((ich eg-single) objekt-liste)
     (when objekt-liste
           (mapc #'(lambda (objekt) (objekt-deselektieren ich objekt)) objekt-liste)))
#+ :aclpc
(defmethod objekte-deselektieren ((ich eg-multi) objekt-liste)
     (when objekt-liste
           (mapc #'(lambda (objekt) (objekt-deselektieren ich objekt)) objekt-liste)))

#+ :aclpc
(defmethod objekt-position ((ich eg-single) item)
     (position item (dialog-item-range ich) :key 'first))
#+ :aclpc
(defmethod objekt-position ((ich eg-multi) item)
     (position item (dialog-item-range ich) :key 'first))

#+ :aclpc
(defmethod set-cell-size ((ich eg-single) h &optional v)
     (unless v
          (setq  h (point-h h)))
     (set-view-size ich (make-point  h (point-v (view-size ich)))))

#+ :aclpc
(defmethod set-cell-size ((ich eg-multi) h &optional v)
     (unless v
          (setq  h (point-h h)))
     (set-view-size ich (make-point  h (point-v (view-size ich)))))
          
#+ :aclpc
(defmethod farbe-neu-berechnen ((ich eg-single))
     ())
#+ :aclpc
(defmethod farbe-neu-berechnen ((ich eg-multi))
     ())

