#+:aclnt
(pushnew :acl2a *features*)

#-:aclnt
(pushnew :aclpc-ignore *features*)

;; parameter, um die reichtige sprachdatei zu laden
;; d -> deutsch
;; e -> englisch
;; unbound -> deutsch
;;

(defvar gl_language 'd)



(defparameter *bib_interpretiert*
     (y-or-n-p (case gl_language
                        (D  "Lade Quelldateien statt kompilierte?")
                        (t  "Load source files instead of compiled ones?")))
     )

;; ladeprogramm fuer die Bibliothek
(defparameter *unser-haupt-fenster*
   #+:aclnt *lisp-frame-window*
   #-:aclnt *lisp-main-window*)

#+:aclpc
(defparameter *.lisp-pathname* (pathname ".lsp"))

#+:aclpc
(defparameter *.fasl-pathname* ".fsl")


;; die logische pfadverwaltung laden
;;

(defparameter *start-dir* 
      (pathname-device *APPLICATION-DIRECTORY*)
     )

(load (concatenate 'string
         *start-dir*
         ":\\biblioth\\zuerst\\log-pfad.lsp"))

#-:acl2a
(load (concatenate 'string
         *start-dir*
         ":\\biblioth\\zuerst\\complete.lsp"))

#-:acl2a
(load (concatenate 'string
         *start-dir*
         ":\\biblioth\\zuerst\\status.lsp"))

(load (concatenate 'string
         *start-dir*
         ":\\biblioth\\_comp_lo.lis"))

(def-logical-pathname "lade-platte"
     (concatenate 'string
         *start-dir*
         ":\\"))

(def-logical-pathname "bibliothek"  "lade-platte;biblioth\\")
(def-logical-pathname "lisp erweiterungen"  "bibliothek;erweit\\")


(if (fboundp 'bib=compile&load)
   (defun b=laden (datei)
        (bib=compile&load datei)
        )
   (defun b=laden (datei)
        (let* ((echte_datei (full-pathname datei))
                (pur (merge-pathnames echte_datei ""))
                (fasl (merge-pathnames echte_datei *.fasl-pathname*))
                (als-lsp (merge-pathnames echte_datei ".lsp"))
                (konvert (merge-pathnames echte_datei ".lis"))
                )
            (cond ((probe-file pur)
                      (load pur))
                     ((probe-file fasl)
                      (load fasl))
                     ((probe-file als-lsp)
                      (load als-lsp))
                     ((probe-file konvert)
                      (load konvert))
                     (t (format t "Die Datei ~a konnte nicht gefunden werden!"
                            echte_datei))
                     )))
   )


;erweiterungen von Franz
#-:acl2a
(progn
    (b=laden "lisp erweiterungen;_updatew")
    (b=laden "lisp erweiterungen;_f2")
    (B=laden "lisp erweiterungen;_fontdi")
    (b=laden "lisp erweiterungen;_windowp")

;; font-fehler beheben
    (b=laden "lisp erweiterungen;fonts")
)

(b=laden "bibliothek;tasten")

;; allgemeine bibliotheksfunktionen quer beet
(def-logical-pathname "bib funktionen"  "bibliothek;bib-fkt\\")


(b=laden "bibliothek;dos&at")
(b=laden "bibliothek;dos-at")
(b=laden "bibliothek;dos-fens")

(b=laden "bib funktionen;unklassi")

(b=laden "bib funktionen;atmakros")
(b=laden "bib funktionen;makclisp")
(b=laden "bib funktionen;fktclisp")
(b=laden "bib funktionen;fkt2")
(b=laden "bib funktionen;fclisp$")
(b=laden "bib funktionen;fktclos")
(b=laden "bib funktionen;fktmcl1")


(case gl_language
    (d
        (b=laden "bibliothek;bibspra:bdeutsch")
        )
    (e
     (b=laden "bibliothek;bibspra:benglish")
     ))

(b=laden "bibliothek;buttonw")
(b=laden "bibliothek;view-wid")
(b=laden "bibliothek;bgr")
(b=laden "bibliothek;qui-draw")
(b=laden "bibliothek;pop-up-m")



(b=laden "bib funktionen;fktmcl4")


;bilder
; stehen momentan in d3-neu/biblio


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; bibliothek objektklassen
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;,

(def-logical-pathname "bibliothek objektklassen"  "bibliothek;bib-obj\\")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;dialog - items
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(def-logical-pathname "bib dialog items"  "bibliothek objektklassen;dialog-i\\")

(b=laden "bib dialog items;b-table")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;dialoge
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(def-logical-pathname "bibliothek dialoge"  "bibliothek objektklassen;dialoge\\")

(b=laden "bibliothek dialoge;b-konfig")
(b=laden "bibliothek dialoge;std-dial")
(b=laden "bibliothek dialoge;b-ja-nei")
(b=laden "bibliothek dialoge;0auswahl")
(b=laden "bibliothek dialoge;b-auswah")
(b=laden "bibliothek dialoge;b-anzeig")
(b=laden "bibliothek dialoge;b-eingab")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;       wissenseditoren 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(def-logical-pathname "wissenseditoren"  "bibliothek objektklassen;wi-edit\\")

;; klapphierarchie
(def-logical-pathname "klapphierarchie"  "wissenseditoren;kl-hier\\")
(b=laden "klapphierarchie;_lade")
(def-logical-pathname "namen such"  "wissenseditoren;namen-su\\")
(b=laden "namen such;_ns-lade")


;;; ende der durchsage


(pushnew :d3-bib *features*)

#|
#-:RUNTIME-SYSTEM
(defun pc-eval (parameter)
     (catch :cancel
         (catch :abort
             (eval parameter))))


#-:RUNTIME-SYSTEM
(top:toploop :eval-fn 'pc-eval)

|#
