(defun b=Linie-in-Bereich-p (Anfangspunkt Endpunkt topleft bottomright)
  "testet, ob sich eine Linie und ein Rechteck schneiden"
  "Autor: Gnter, 18.1.93"
  (locally
    (declare (optimize (speed 3)(safety 0))
             (fixnum Anfangspunkt-x Anfangspunkt-y Endpunkt-x Endpunkt-y x1 x2 y1 y2))
  (let ((Anfangspunkt-x (point-h (the fixnum Anfangspunkt)))
        (Anfangspunkt-y (point-v (the fixnum Anfangspunkt)))
        (Endpunkt-x (point-h (the fixnum Endpunkt)))
        (Endpunkt-y (point-v (the fixnum Endpunkt)))
        (x1 (point-h (the fixnum topleft)))
        (x2 (point-h (the fixnum bottomright)))
        (y1 (point-v (the fixnum topleft)))
        (y2 (point-v (the fixnum bottomright))))
    (when (or (= (the fixnum x1) (the fixnum x2)) (= (the fixnum y1) (the fixnum y2))               ;das `when testet, ob sich das Rechteck, das die Linie umschliet, mit dem Rechteck schneidet
              (and (> (the fixnum x1) (the fixnum Anfangspunkt-x)) (> (the fixnum x1) (the fixnum Endpunkt-x)))
              (and (< (the fixnum x2) (the fixnum Anfangspunkt-x)) (< (the fixnum x2) (the fixnum Endpunkt-x)))
              (and (> (the fixnum y1) (the fixnum Anfangspunkt-y)) (> (the fixnum y1) (the fixnum Endpunkt-y)))
              (and (< (the fixnum y2) (the fixnum Anfangspunkt-y)) (< (the fixnum y2) (the fixnum Endpunkt-y))))
      (return-from b=Linie-in-Bereich-p nil))
    (let ((Linie-dx (- Endpunkt-x Anfangspunkt-x))   ;x-Koordinate des Richtungsvektors der Geraden
          (Linie-dy (- Endpunkt-y Anfangspunkt-y)))  ;y-Koordinate des Richtungsvektors der Geraden
      (flet ((Seite (x y)                             ;`Seite liefert zurck, auf welcher Seite der Punkt (x, y) liegt
               (let* ((dx (the fixnum (- (the fixnum x) (the fixnum Anfangspunkt-x))))      
                      (dy (the fixnum (- (the fixnum y) (the fixnum Anfangspunkt-y))))
                      (Kreuz (the fixnum (- (the fixnum (* (the fixnum dx) (the fixnum Linie-dy))) 
                                            (the fixnum (* (the fixnum dy) (the fixnum Linie-dx)))))))   ;Kreuzprodukt des Richtungsvektor und ...
                 (plusp (the fixnum kreuz)))))
        (if (eq (plusp (the fixnum linie-dx)) (plusp (the fixnum linie-dy)))
          (neq (seite x2 y1) (seite x1 y2))
          (neq (seite x1 y1) (seite x2 y2))
          ))))))


(defun b=punkt-auf-linie-p (punkt anfangspunkt endpunkt &key (delta 2) &allow-other-keys)
  "Autor: Gnter, 18.1.93"
  (let* ((deltapoint (make-point delta delta)))
    (b=linie-in-bereich-p anfangspunkt endpunkt
                          (subtract-points (the fixnum punkt) (the fixnum deltapoint))
                          (add-points (the fixnum punkt) (the fixnum deltapoint)))))

#|
alte version von klaus
(defun b=punkt-auf-linie-p (punkt punkt-1 punkt-2 
                                  &key (delta 4)
                                  (Fenster nil))
;geaendert, Ute, 10.06.90
;wenn die Linie senkrecht oder waagrecht ist, wird ein einfacher Test
;bevorzugt, der kein extra Fenster erzeugen muss
(let ((x1 (point-h punkt-1))
      (y1 (point-v punkt-1))
      (x2 (point-h punkt-2))
      (y2 (point-v punkt-2)))
  (cond ((eql x1 x2) (b=Punkt-auf-hv-Linie-p Punkt punkt-1 punkt-2 :Richtung-der-Linie :vertikal   :delta delta))
        ((eql y1 y2) (b=Punkt-auf-hv-Linie-p Punkt punkt-1 punkt-2 :Richtung-der-Linie :horizontal :delta delta))
        (t
         (let* ((window (if Fenster Fenster (make-instance 'window :window-show NIL)))
                (steigung (if (= 0 (- x2 x1)) NIL (/ (- y2 y1) (- x2 x1))))
                (alpha (if steigung (atan steigung) (/ pi 2)))
                (x (round (* delta (sin alpha))))
                (y (round (* delta (cos alpha))))
                (click-viereck NIL)
                (punkt-enthalten NIL))
           (open-region window)
           (move-to window (- x1 x) (+ y1 y))
           (line-to window (- x2 x) (+ y2 y))
           (line-to window (+ x2 x) (- y2 y))
           (line-to window (+ x1 x) (- y1 y))
           (line-to window (- x1 x) (+ y1 y))
           (setq click-viereck (close-region window))  
           (setq punkt-enthalten (point-in-region-p click-viereck punkt))
           (dispose-region click-viereck)
           (unless Fenster (window-close window))
           punkt-enthalten)))))

|#


(defun b=Punkt-auf-hv-Linie-p (Punkt Anfangspunkt Endpunkt &key (delta 4)
                                        (Richtung-der-Linie nil))
  "prueft, ob ein Punkt auf einer durch Anfangspunkt und Endpunkt beschriebenen
horizontalen oder vertikalen Linie liegt mit Abweichungstoleranz delta"
  ;Bem: die Funktion ist analog zu b=Punkt-auf-Linie nur dass hier die Voraussetzung
  ;     gemacht wird dass die Linie entweder genau horizontal oder vertikal ist
  ;     -> die Ueberpruefung ist effizienter und es muss kein neues Fenster angelegt werden
  ;        was eventuell zum Deselektieren des aktuellen Fensters fuehrt
  ;:Richtung-der-Linie: :vertikal oder :horizontal, falls man die Richtung schon weiss  
  ;Ute, 10.06.90
  ;verbessert Klaus, 6.10.92, so da  auch Linien von rechts nach links bzw. von
  ;unten nach oben erkannt werden.
  (let ((Anfangspunkt-h (point-h Anfangspunkt))
        (Anfangspunkt-v (point-v Anfangspunkt))
        (Endpunkt-h (point-h Endpunkt))
        (Endpunkt-v (point-v Endpunkt))
        (Punkt-h (point-h Punkt))
        (Punkt-v (point-v Punkt)))
    (unless Richtung-der-Linie
      (cond ((eql Anfangspunkt-h Endpunkt-h) 
             (setq Richtung-der-Linie :vertikal))
            ((eql Anfangspunkt-v Endpunkt-v) 
             (setq Richtung-der-Linie :horizontal))
            (t nil)))
    (case Richtung-der-Linie
      (:horizontal (and (or (<= Anfangspunkt-h Punkt-h Endpunkt-h) (<= Endpunkt-h Punkt-h Anfangspunkt-h))
                        (<= (- Anfangspunkt-v delta) Punkt-v (+ Anfangspunkt-v delta))))
      (:vertikal (and (or (<= Anfangspunkt-v Punkt-v Endpunkt-v) (<= Endpunkt-v Punkt-v Anfangspunkt-v))
                      (<= (- Anfangspunkt-h delta) Punkt-h (+ Anfangspunkt-h delta))))
      (t "falsche Voraussetzung"))))

#|
Beispiele:
(b=Punkt-auf-hv-Linie-p (make-point 10 10) (make-point 8 10) (make-point 20 10))
-> t
(b=Punkt-auf-hv-Linie-p (make-point 10 5) (make-point 8 10) (make-point 20 10) :Richtung-der-Linie :horizontal :delta 6)
-> t
(b=Punkt-auf-hv-Linie-p (make-point 10 3) (make-point 8 10) (make-point 20 10) :delta 6)
-> nil
(b=Punkt-auf-hv-Linie-p (make-point 10 3) (make-point 8 12) (make-point 20 10))
-> "falsche Voraussetzung"
|#

(defun b=Rechtecke-umschliessendes-Rechteck (Rechtecke)
  ;Rechtecke als Liste von Paaren mit topleft und bottomright-Punkt
  ;Ute, 4.12.92
  (let ((topleft-h nil)
        (topleft-v nil)
        (bottomright-h nil)
        (bottomright-v nil))
    (cond ((and Rechtecke
                (> (length Rechtecke) 1))
           (setq topleft-h (apply #'min (mapcar #'(lambda (Rechteck)
                                                    (point-h (first Rechteck)))
                                                Rechtecke)))
           (setq topleft-v (apply #'min (mapcar #'(lambda (Rechteck)
                                                    (point-v (first Rechteck)))
                                                Rechtecke)))
           (setq bottomright-h (apply #'max (mapcar #'(lambda (Rechteck)
                                                        (point-h (second Rechteck)))
                                                    Rechtecke)))
           (setq bottomright-v (apply #'max (mapcar #'(lambda (Rechteck)
                                                        (point-v (second Rechteck)))
                                                    Rechtecke)))
           (list (make-point topleft-h topleft-v)
                 (make-point bottomright-h bottomright-v)))
          (t (first Rechtecke)))))
             

(defun b=Quadrat-um-Punkt (Punkt &key (delta 4))
  "die Funktion liefert ein Rechteck (Liste aus dem Punkt oben links und
dem Punkt unten rechts) mit Punkt als Mittelpunkt"
  ;Eingabe: Mittelpunkt des Rechtecks
  ;         :delta = vertikaler und horizontaler Abstand vom Mittelpunkt
  ;Ausgabe: Liste aus dem Punkt oben links und dem Punkt unten rechts
  ;         zur Beschreibung des Rechtecks
  ;Ute/Karsten 09.06.90
  (list (subtract-points Punkt (make-point delta delta))
        (add-points Punkt (make-point delta delta))))

#|
Beispiel:
(let ((Rechteck (b=Quadrat-um-Punkt (make-point 10 10))))
  (format nil "Rechteck mit linkem oberen Punkt ~a und rechtem unteren Punkt ~a."
          (point-string (first Rechteck)) (point-string (second Rechteck))))
-> "Rechteck mit linkem oberen Punkt #@(6 6) und rechtem unteren Punkt #@(14 14)."
|#

(defun b=punkt-in-dreieck-p (punkt eck-1 eck-2 eck-3 &optional (fenster NIL))
  #|Autor: Klaus, juni 1990|#

(let* ((window (if Fenster Fenster (make-instance 'window :window-show NIL)))
         (click-dreieck NIL)
         (punkt-enthalten NIL))
  (open-region window)
  (move-to window eck-1)
  (line-to window eck-2)
  (line-to window eck-3)
  (line-to window eck-1)
  (setq click-dreieck (close-region window))  
  (setq punkt-enthalten (point-in-region-p click-dreieck punkt))
  (dispose-region click-dreieck)
  (window-close Fenster)
  punkt-enthalten))

 
(defun b=rect1-in-rect2-p (tl1 br1 tl2 br2)
  #|Autor: Klaus, juni 1990|#

  (rlet (( r :rect
             :topleft tl2
             :bottomright br2))
    (and (point-in-rect-p r tl1) (point-in-rect-p r br1))))

(defun b=zeichne-linie (anf-punkt end-punkt port &key (liniendicke 1))
  #|Autor: Klaus, juni 1990|#
  (with-port port
    (when (> liniendicke 1) (_PenSize :long (make-point liniendicke liniendicke)))
    (_Moveto :long anf-punkt)
    (_Lineto :long end-punkt)))

(defun b=zeichne-Pfeil (anf-punkt end-punkt port &key 
                                  (liniendicke 1)
                                  (spitzen-winkel 40)
                                  (spitzen-laenge 11))
  #|Autor: Klaus, juni 1990|#
  (b=zeichne-linie anf-punkt end-punkt port 
                   :liniendicke liniendicke)
  (b=zeichne-Pfeilspitze  anf-punkt end-punkt port ;vorher: b-zeichne-pfeile -> ist nicht definiert
                    ;:liniendicke liniendicke gibt es nicht !!!
                    :spitzen-winkel spitzen-winkel
                    :spitzen-laenge spitzen-laenge))

(defun b=zeichne-DoppelPfeil (anf-punkt end-punkt port &key 
                                  (liniendicke 1)
                                  (spitzen-winkel 40)
                                  (spitzen-laenge 11))
  #|Autor: Klaus, juni 1990|#
  (b=zeichne-linie anf-punkt end-punkt port 
                   :liniendicke liniendicke)
  (b=zeichne-Pfeilspitze anf-punkt end-punkt port
                    :spitzen-winkel spitzen-winkel
                    :spitzen-laenge spitzen-laenge)
  (b=zeichne-Pfeilspitze end-punkt anf-punkt port
                    :spitzen-winkel spitzen-winkel
                    :spitzen-laenge spitzen-laenge))

(defun b=zeichne-Pfeilspitze (anf-punkt end-punkt port
                                        &key (spitzen-winkel 40)
                                             (spitzen-laenge 11))
    #|Autor: Klaus, juni 1990|#
(let* ((groesse (make-point spitzen-laenge spitzen-laenge))
         (halber-spitzen-winkel (floor (/ spitzen-winkel 2)))
         (diff (subtract-points end-punkt anf-punkt))
         (quotient (if (/= 0 (point-h diff)) 
                     (/ (point-v diff) (point-h diff)) NIL))
         (winkel (if quotient 
                   (+ (round (* (/ (atan quotient) PI) 180)) 90) 
                   (if (> 0 (point-v diff)) 180  0))))
    (when (< 0 (point-h diff)) 
      (when quotient (setq winkel (+ 180 winkel))))
    (with-port port
      (b-with-rectangle-arg (r (subtract-points end-punkt groesse) (add-points end-punkt groesse))
                            (_PaintArc :ptr r :word (- winkel halber-spitzen-winkel) :word spitzen-winkel)))))
#|Beispiel:
(setq x (make-instance 'window))
(b=zeichne-doppelpfeil #@(10 10) #@(100 100) (wptr x) :liniendicke 2)
|#





(defun b=Linie-zeichnen (view anf-punkt end-punkt &key (liniendicke 1) (traps-p T))
  #|Autor: Ute/Andreas 6/91, gendert: Juli 93|#
  ;Zeichnen geht jetzt ohne Traps, es mssen aber dann alle with-port-Aufrufe eliminiert werden !!!, ff.
  (if traps-p
    (with-port (wptr view)
      (when (> liniendicke 1) (_PenSize :long (make-point liniendicke liniendicke)))
      (_Moveto :long anf-punkt)
      (_Lineto :long end-punkt))
    (let ((pen-size-alt (pen-size view)))
      (when (> liniendicke 1) (set-pen-size view (make-point liniendicke liniendicke)))
      (Move-to view anf-punkt)
      (Line-to view end-punkt)
      (set-pen-size view pen-size-alt))))

#| vor Andreas nderung:

(defun b=Linie-zeichnen (view anf-punkt end-punkt &key (liniendicke 1))
  
  (with-port (wptr view)
    (when (> liniendicke 1) (_PenSize :long (make-point liniendicke liniendicke)))
    (_Moveto :long anf-punkt)
    (_Lineto :long end-punkt)))
|#


(defun b=Pfeil-zeichnen (view anf-punkt end-punkt &key 
                                  (liniendicke 1)
                                  (spitzen-winkel 40)
                                  (spitzen-laenge 11)
                                  (traps-p T))
  #|Autor: Ute/Andreas 6/91|#
  (b=Linie-zeichnen view anf-punkt end-punkt 
                   :liniendicke liniendicke
                   :traps-p traps-p)
  (b=Pfeilspitze-zeichnen view anf-punkt end-punkt
                         :spitzen-winkel spitzen-winkel
                         :spitzen-laenge spitzen-laenge
                         :traps-p traps-p))


#| vor Andreas nderung:
(defun b=Pfeil-zeichnen (view anf-punkt end-punkt &key 
                                  (liniendicke 1)
                                  (spitzen-winkel 40)
                                  (spitzen-laenge 11))
  #|Autor: Ute/Andreas 6/91|#
  (b=Linie-zeichnen view anf-punkt end-punkt 
                   :liniendicke liniendicke)
  (b=Pfeilspitze-zeichnen view anf-punkt end-punkt
                         :spitzen-winkel spitzen-winkel
                         :spitzen-laenge spitzen-laenge))
|#

(defun b=DoppelPfeil-zeichnen (view anf-punkt end-punkt &key 
                                      (liniendicke 1)
                                      (spitzen-winkel 40)
                                      (spitzen-laenge 11)
                                      (traps-p T))
  #|Autor: Ute/Andreas 6/91|#
  (b=Linie-zeichnen view anf-punkt end-punkt 
                    :liniendicke liniendicke
                    :traps-p traps-p)
  (b=Pfeilspitze-zeichnen view anf-punkt end-punkt
                          :spitzen-winkel spitzen-winkel
                          :spitzen-laenge spitzen-laenge
                          :traps-p traps-p)
  (b=Pfeilspitze-zeichnen view end-punkt anf-punkt 
                          :spitzen-winkel spitzen-winkel
                          :spitzen-laenge spitzen-laenge
                          :traps-p traps-p))

#| vor Andreas nderung:
(defun b=DoppelPfeil-zeichnen (view anf-punkt end-punkt &key 
                                      (liniendicke 1)
                                      (spitzen-winkel 40)
                                      (spitzen-laenge 11))
  #|Autor: Ute/Andreas 6/91|#
  (b=Linie-zeichnen view anf-punkt end-punkt 
                    :liniendicke liniendicke)
  (b=Pfeilspitze-zeichnen view anf-punkt end-punkt
                          :spitzen-winkel spitzen-winkel
                          :spitzen-laenge spitzen-laenge)
  (b=Pfeilspitze-zeichnen view end-punkt anf-punkt 
                          :spitzen-winkel spitzen-winkel
                          :spitzen-laenge spitzen-laenge))
|#



(defun b=Pfeilspitze-zeichnen (view anf-punkt end-punkt
                                    &key (spitzen-winkel 40)
                                    (spitzen-laenge 11)
                                    (traps-p T))
  #|Autor: Ute/Andreas 6/91 ;Gendert von Andreas 7/93|#
  (let* ((groesse (make-point spitzen-laenge spitzen-laenge))
         (halber-spitzen-winkel (floor (/ spitzen-winkel 2)))
         (diff (subtract-points end-punkt anf-punkt))
         (quotient (if (/= 0 (point-h diff)) 
                     (/ (point-v diff) (point-h diff)) NIL))
         (winkel (if quotient 
                   (+ (round (* (/ (atan quotient) PI) 180)) 90) 
                   (if (> 0 (point-v diff)) 180  0))))
    (when (< 0 (point-h diff)) 
      (when quotient (setq winkel (+ 180 winkel))))
  (if traps-p
    (with-port (wptr view)
      (b-with-rectangle-arg (r (subtract-points end-punkt groesse) (add-points end-punkt groesse))
                            (_PaintArc :ptr r :word (- winkel halber-spitzen-winkel) :word spitzen-winkel)))
    (b-with-rectangle-arg (r (subtract-points end-punkt groesse) (add-points end-punkt groesse))
      (Paint-Arc view (- winkel halber-spitzen-winkel) spitzen-winkel r)))))


#| vor Andreas nderung:
(defun b=Pfeilspitze-zeichnen (view anf-punkt end-punkt
                                       &key (spitzen-winkel 40)
                                       (spitzen-laenge 11))
  #|Autor: Ute/Andreas 6/91|#
  (let* ((groesse (make-point spitzen-laenge spitzen-laenge))
         (halber-spitzen-winkel (floor (/ spitzen-winkel 2)))
         (diff (subtract-points end-punkt anf-punkt))
         (quotient (if (/= 0 (point-h diff)) 
                     (/ (point-v diff) (point-h diff)) NIL))
         (winkel (if quotient 
                   (+ (round (* (/ (atan quotient) PI) 180)) 90) 
                   (if (> 0 (point-v diff)) 180  0))))
    (when (< 0 (point-h diff)) 
      (when quotient (setq winkel (+ 180 winkel))))
    (with-port (wptr view)
      (b-with-rectangle-arg (r (subtract-points end-punkt groesse) (add-points end-punkt groesse))
                            (_PaintArc :ptr r :word (- winkel halber-spitzen-winkel) :word spitzen-winkel)))))
|#




#|Beispiel:
(defobject *u-g* *b-graphics-dialog*)

(defobfun (exist *u-g*) (init-list)
  (usual-exist init-list)
  (set-field-size #@(1000 1000)))
  


(setq ute-graphics-dialog (make-instance '*u-g*))

(defobfun (view-draw-contents (view ute-graphics-dialog)) ()
  (usual-view-draw-contents)
  (print `view-draw-contents)
  (b=doppelpfeil-zeichnen (self) #@(10 10) #@(100 100) :liniendicke 2))

(view-draw-contents ute-graphics-dialog)



;so funktionierts leider nicht:

(setq ute-graphics-dialog (make-instance '*u-g*))

(defobfun (view-draw-contents ute-graphics-dialog) ()   ;muss offensichtlich unbedingt zum View und nicht zum *graphics-dialog* definiert werden !!!
  (usual-view-draw-contents)
  (print `view-draw-contents)
  (b=doppelpfeil-zeichnen (view) #@(10 10) #@(100 100) :liniendicke 2))

(view-draw-contents ute-graphics-dialog)


  
|#
