(defclass *b-graphics-window* (*b-button-window*)
       (
        (scroller :initarg :scroller :initform '*b-scroller-view*
         :accessor bgw-scroller)
        (scroller-parameter :initarg :scroller-parameter :initform nil :accessor bgw-scroller-parameter)
        )
        
      (:default-initargs
       :user-resizable t
       :user-movable t
       :user-scrollable nil)
      )                     
     
(defmethod initialize-instance :after ((ich *b-graphics-window*) &rest init-list
                                                           ;&key (scroller  '*b-scroller-view*)
                                                           )
     
     (setf (bgw-scroller ich)
             (apply #'open-dialog nil (bgw-scroller ich) ;scroller
                     ich
                     :pop-up-p nil
                    :title ""
                     :window-exterior (make-box 0 0
                                                      (window-interior-width ich)
                                                      (- (window-interior-height ich)
                                                         (buttonzeile-hoehe ich)))
                  (bgw-scroller-parameter ich))))

(defclass *b-graphics-scroller* (*b-window*)
      (   
       (field-size :initform nil 
          :initarg :field-size :accessor bs-field-size)
       )
     (:default-initargs
      :user-resizable nil
      :user-movable nil
      :user-scrollable t)
     )                     

(defclass *b-scroller-view* (*b-graphics-scroller*)
      ())

(defmethod view-scroll-position ((ich mac-fenster-mixin))
     (scroll-position ich))

(defmethod view-scroll-position ((ich *b-graphics-window*))
     (view-scroll-position (view ich)))

(defmethod initialize-instance :after ((ich *b-graphics-scroller*) &rest init-list)
     (declare (ignore init-list))
     (when (bs-field-size ich)
          (set-field-size ich  (bs-field-size ich))))

(defmethod b=view-ist-installiert-p ((ich *b-graphics-window*))
     (typep (bgw-scroller ich) 'view))

(defmethod resize-window :after  ((ich *b-graphics-window*) position)
     (when (b=view-ist-installiert-p ich)
         (let ((vorher (field-size ich)))
              (reshape-window-exterior
                  (bgw-scroller ich)
                  (make-box 0 0
                        (window-interior-width ich)
                        (- (window-interior-height ich)
                           (buttonzeile-hoehe ich) 
                           )))
              (set-field-size ich vorher))))

(defmethod view ((ich *b-graphics-window*))
     (bgw-scroller ich)
      )

(defmethod win ((ich *b-graphics-window*))
     (bgw-scroller ich)
      )

(defmethod field-size ((ich *b-graphics-window*))
      (field-size (view ich))
      )

(defmethod  field-size ((ich mac-fenster-mixin))
      (multiple-value-bind
               (x y)
              (scroll-range ich)
             (make-point
                    (+ x (visible-box-width ich))
                    (+ y (visible-box-height ich)))))


(defmethod set-field-size ((ich *b-graphics-window*) h &optional v)
      (set-field-size (view ich) h v))

(defmethod set-field-size ((ich mac-fenster-mixin) h &optional v)
      (let* (
                (size
                    (if v (make-point h v) h))
                (punkt
                      (subtract-points size
                            (make-point
                                   (visible-box-width ich)
                                   (visible-box-height ich)))))
          (set-scroll-range ich (point-h punkt)(point-v punkt) nil nil)))

(defmethod set-view-scroll-position ((ich *b-graphics-window*)   x &optional y)
      (set-view-scroll-position (view ich) x y))
                                                                       
(defmethod set-view-scroll-position ((ich mac-fenster-mixin)
                                                                       x &optional y)
      (let ((punkt (if y (make-point x y) x)))
          (scroll-to ich punkt)))

(defmethod invalidate-view ((ich *b-graphics-window*))
      )

#|
(setq der (m->a=erzeuge-fenster-local '*b-graphics-window*))


(m->a=erzeuge-fenster '*b-graphics-window*
     :view-size (make-point 100 100)
     :view-position #@(200 200)
 :buttons (list (m->a=erzeuge-dialog-item '*b-button-dialog-item*
                           :dialog-item-text "Stefan")
                     (m->a=erzeuge-dialog-item '*b-button-dialog-item*
                      :dialog-item-text "Karsten")))
                     
|#